% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statistical_test.R
\name{get_wilcox_test}
\alias{get_wilcox_test}
\title{get_wilcox_test}
\usage{
get_wilcox_test(heteroplasmy_matrix, cluster, label_1, label_2, index = NULL)
}
\arguments{
\item{heteroplasmy_matrix}{Third element returned by \emph{get_heteroplasmy}.}

\item{cluster}{Vector specifying a partition of the samples.}

\item{label_1}{Character name of a first label included in cluster. It
denotes the first group used for the Wilcoxon test}

\item{label_2}{Character name of a second label included in cluster and
different from label_1. it denotes the second group used for the Wilcoxon
test.}

\item{index}{Fifth element returned by \emph{get_heteroplasmy}.}
}
\value{
It returns a numeric vector of length equal to n_row in matrix. Each element
stands for a base and it contains the adjusted p-value (FDR), obtained in
unpaired two-samples Wilcoxon test from the comparison of the heteroplasmy
between the label_1 and label_2 group.
}
\description{
get_wilcox_test
}
\seealso{
\url{https://www.rdocumentation.org/packages/stats/versions/3.6.2/topics/wilcox.test}
}
\author{
Gabriele Lubatti \email{gabriele.lubatti@helmholtz-muenchen.de}
}
