% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{.getDefaultNlsValues}
\alias{.getDefaultNlsValues}
\title{Default NLS values}
\usage{
.getDefaultNlsValues(x, y, start = list(), lower = list(), upper = list())
}
\arguments{
\item{x}{index series or time series.}

\item{y}{values or list of values to regress (should not be logged, must be strictly greater than zero).}

\item{start}{a named list of starting estimates. The coefficients specified in this list will not be calculated.}

\item{lower}{a named list of lower bounds. The coefficients specified in this list will not be calculated.}

\item{upper}{a named list of upper bounds. The coefficients specified in this list will not be calculated.}
}
\value{
the default values of \code{start}, \code{lower} and \code{upper} for NLS regression.
}
\description{
Gives default values for NLS regression from \code{x} and \code{y} values.
The method of calculating default values differs depending on the amount of data available in \code{y}.
Default values can be pre-set by providing them in the \code{start}, \code{lower} and \code{upper} arguments.
}
\details{
default values are calculated as follows:
\itemize{
\item \code{start}
\itemize{
\item \code{N0}: the minimum value of \code{y}
\item \code{Nmax}: the maximum value of \code{y}
\item \code{mu}:
\itemize{
\item \verb{if length(y) <= }\link{THRESHOLD_FEW_DATA}: the greatest slope between two contiguous points (on logged \code{y} values)
\item \verb{else}: the linear regression on data positioned in the middle ±25\% of the amplitude on logged y
}
\item \code{lambda}: the highest value of \code{x} which is within the lowest 5\% of amplitude of \code{y}
}
\item \code{lower}
\itemize{
\item \code{N0}: the smallest value greater than zero calculated with \code{1/.Machine$double.xmax}
\item \code{Nmax}: the mean value of \code{y}
\item \code{mu}: the amplitude on \code{y} divided by the amplitude on \code{x}
\item \code{lambda}:the minimum value of \code{x}
}
\item \code{upper}
\itemize{
\item \code{N0}: the mean value of \code{y}
\item \code{Nmax}: twice the max value of \code{y}
\item \code{mu}:
\itemize{
\item \verb{if length(y) <= }\link{THRESHOLD_FEW_DATA}: the amplitude on logged \code{y} divided by the smallest step between two contiguous \code{x} values
\item \verb{else}: the greatest slope between two contiguous points (on logged \code{y} values)
}
\item \code{lambda}: the maximum value of \code{x}
}
}

Note that it is possible, particularly when there is little data, that linear regression for \code{start$mu} is not possible, hence the presence of condition with \link{THRESHOLD_FEW_DATA}.
}
\examples{
# Example data
x = c(0.00, 5.26, 10.53, 15.79, 21.05, 26.32, 31.58, 36.84, 42.11, 47.37, 52.63,
      57.89, 63.16, 68.42, 73.68, 78.95, 84.21, 89.47, 94.74, 100.00)
y = c(0.15, 0.15, 0.15, 0.16, 0.19, 0.26, 0.38, 0.58, 0.85, 1.18, 1.53, 1.86,
      2.15, 2.38, 2.55, 2.66, 2.78, 2.85, 2.89, 2.93)

# Simple example
values = .getDefaultNlsValues(x, y)
cat("N0=", values$start$N0, " with limits [", values$lower$N0, ", ", values$upper$N0,"]", sep="")
## N0=0.15 with limits [5.562685e-309, 1.4315]

# Example with specifying a starting value (which will therefore not be calculated)
values = .getDefaultNlsValues(x, y, start=list(N0=0.1))
cat("N0=", values$start$N0, " with limits [", values$lower$N0, ", ", values$upper$N0,"]", sep="")
## N0=0.1 with limits [5.562685e-309, 1.4315]
}
