% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KRV_helper.R
\name{inner.KRV}
\alias{inner.KRV}
\title{Kernel RV Coefficient Test; Inner Function}
\usage{
inner.KRV(
  y = NULL,
  X = NULL,
  adjust.type,
  kernel.otu,
  kernel.y,
  returnKRV = FALSE,
  returnR2 = FALSE
)
}
\arguments{
\item{y}{A numeric n by p matrix of p continuous phenotype variables and 
sample size n (default = NULL). If it is NULL, a 
phenotype kernel matrix must be entered for "kernel.y". Defaults to NULL.}

\item{X}{A numeric n by q matrix, containing q additional covariates 
(default = NULL). If NULL, an intercept only model is used. If the first
column of X is not uniformly 1, then an intercept column will be added.}

\item{adjust.type}{Possible values are "none" (default if X is null), 
"phenotype" to adjust only the y variable (only possible if y is a numeric 
phenotype matrix rather than a pre-computed kernel), or "both" to adjust 
both the X and Y kernels.}

\item{kernel.otu}{A numeric OTU n by n kernel matrix or a list of matrices, 
where n is the sample size. It can be constructed from microbiome data, such 
as by transforming from a distance metric.}

\item{kernel.y}{Either a numerical n by n kernel matrix for phenotypes or a 
method to compute the kernel of phenotype. Methods are "Gaussian" or "linear". 
A Gaussian kernel (kernel.y="Gaussian") can capture the general relationship 
between microbiome and phenotypes; a linear kernel (kernel.y="linear") 
may be preferred if the underlying relationship is close to linear.}

\item{returnKRV}{A logical indicating whether to return the KRV statistic. Defaults to FALSE.}

\item{returnR2}{A logical indicating whether to return the R-squared coefficient. Defaults to FALSE.}
}
\value{
Returns a p-value for the candidate kernel matrix
    \item{pv}{p-value for the candidate kernel matrix}
    \item{KRV}{KRV statistic for the candidate kernel matrix. Only returned if returnKRV = TRUE.}  
    \item{R2}{R-squared for the candidate kernel matrix. Only returned if returnR2 = TRUE.}
}
\description{
Function called when user calls function KRV. For each kernel matrix inputted into KRV, KRV runs inner.KRV on that 
kernel with the inputted kernel.y outcome matrix.
}
\details{
y and X (if not NULL) should all be numerical matrices or vectors with the same number of rows.

 Ks should be a list of n by n matrices or a single matrix. If you have distance metric from metagenomic data, each kernel can be
 constructed through function D2K. Each kernel can also be constructed through other mathematical approaches.

 Missing data is not permitted. Please remove all individuals with missing y, X, Ks prior to analysis
 
Parameter "method" only concerns how kernel specific p-values are generated. When Ks is a list of multiple kernels, omnibus
p-value is computed through permutation from each individual p-value, which are calculated through method of choice.
}
\references{
Zhan, X., Plantinga, A., Zhao, N., and Wu, M.C. A Fast Small-Sample Kernel Independence Test for Microbiome Community-Level 
Association Analysis. Biometrics. 2017 Mar 10. doi: 10.1111/biom.12684.
}
\author{
Haotian Zheng, Xiang Zhan, Ni Zhao
}
