% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/5.topological.R
\name{net_par}
\alias{net_par}
\alias{c_net_index}
\title{Calculate all topological indexes of a network}
\usage{
net_par(
  go,
  mode = c("v", "e", "n", "all"),
  fast = TRUE,
  remove_negative = FALSE,
  only_topological = FALSE
)

c_net_index(go, force = FALSE)
}
\arguments{
\item{go}{igraph or metanet}

\item{mode}{calculate what? c("v", "e", "n", "all")}

\item{fast}{less indexes for faster calculate ?}

\item{remove_negative}{remove negative edge or not? default: FALSE}

\item{only_topological}{only return topological indexes}

\item{force}{replace existed net_par}
}
\value{
a 3-elements list
\item{n_index}{indexs of the whole network}
\item{v_index}{indexs of each vertex}
\item{e_index}{indexs of each edge}
}
\description{
Calculate all topological indexes of a network

Add topological indexes for a network
}
\examples{
igraph::make_graph("Walther") \%>\% net_par()
c_net_index(co_net) -> co_net_with_par
}
\seealso{
Other topological: 
\code{\link{extract_sample_net}()},
\code{\link{fit_power}()},
\code{\link{get_group_skeleton}()},
\code{\link{links_stat}()},
\code{\link{nc}()},
\code{\link{rand_net}()},
\code{\link{rand_net_par}()},
\code{\link{smallworldness}()}
}
\concept{topological}
