% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/metsize.R
\name{metsize}
\alias{metsize}
\title{Metsize}
\usage{
metsize(
  pilot = pilot,
  n1 = 4,
  n2 = 4,
  p = 200,
  prop = 0.25,
  covars = covars,
  ncovar = 0,
  model = "PPCA",
  plot.prop = FALSE,
  target.fdr = 0.05,
  Targeted = FALSE
)
}
\arguments{
\item{pilot}{A matrix containing pilot data, if available.}

\item{n1}{Sample group 1 minimum sample size to consider.}

\item{n2}{Sample group 2 minimum sample size to consider.}

\item{p}{Number of bins in the data.}

\item{prop}{Expected proportion of significant bins.}

\item{covars}{Matrix of covariates, if available. Categorical covariates
should be included as X-1 dummy variables for a covariate with X levels.}

\item{ncovar}{The number of covariates present. For Z numeric covariates and Y categorical covariates with X total levels, this should be Z + X - Y.}

\item{model}{The chosen model.}

\item{plot.prop}{TRUE/FALSE should sample size be calculated for varying proportions of significant bins?}

\item{target.fdr}{The desired false discovery rate.}

\item{Targeted}{TRUE/FALSE is the experiment intended as targeted analysis?}
}
\value{
List containing the estimated sample size with the per-group sample
size breakdown, results of FDR calculations for each sample size tested,
results for varying the proportion of significant metabolites, the number
of bins input, the number of covariates input, the model type used, the
input minimum sample sizes for group 1 and group 2, and the desired FDR.
}
\description{
Function to estimate sample size required to achieve a desired statistical
power.
}
\examples{
metsize(pilot = NULL, n1 = 4, n2 = 4, p = 200, prop = 0.2, covars = NULL,
    ncovar = 0, model = "PPCA", plot.prop = FALSE, target.fdr = 0.10,
    Targeted = FALSE)
metsize(pilot = NULL, n1 = 6, n2 = 4, p = 100, prop = 0.1, covars = NULL,
    ncovar = 2, model = "PPCCA", plot.prop = FALSE, target.fdr = 0.05,
    Targeted = TRUE)
}
\references{
G. Nyamundanda, I. C. Gormley, Y. Fan, W. M. Gallagher and L. Brennan, BMC Bioinformatics, 2013, 14, 338.
}
