% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data-documentation.R
\name{VA_df}
\alias{VA_df}
\title{Veteran's Administration Lung Cancer Trial}
\format{
A data frame with 137 observations and 8 variables:
\describe{
  \item{stime}{A numeric value representing the survival time (in days).}
  \item{status}{A numeric value indicating the status of the patient (1 if the patient died, 0 otherwise).}
  \item{treat}{A factor indicating the treatment group (e.g., treatment A or B).}
  \item{age}{A numeric value representing the age of the patient (in years).}
  \item{Karn}{A numeric value representing the Karnofsky performance status score.}
  \item{diag.time}{A numeric value indicating the time since diagnosis (in days).}
  \item{cell}{A factor indicating the cell type of the lung cancer (with 4 possible levels).}
  \item{prior}{A factor indicating prior treatment (yes/no).}
}
}
\source{
Data collected from the Veteran's Administration Lung Cancer Trial.
}
\usage{
data(VA_df)
}
\description{
The dataset name has been changed to 'VA_df' to avoid confusion with other datasets from
packages in the R ecosystem and to follow the naming conventions of the 'MedDataSets' package.
The suffix '_df' indicates that this dataset is a data frame, helping to distinguish it from
other datasets within the package and from those in the broader R ecosystem. The original content
of the dataset has not been modified in any way.
}
\details{
This dataset contains data from the Veteran's Administration Lung Cancer Trial, which includes
information on patients diagnosed with lung cancer, their treatment, and other relevant variables.
}
