% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MST_Main.R
\name{Fit_Skewt}
\alias{Fit_Skewt}
\title{Matrix Skew t Parameter Estimation}
\usage{
Fit_Skewt(X, Tol = 0.001, max_iter = 1000)
}
\arguments{
\item{X}{A list of matrices of the same size}

\item{Tol}{The tolerance of the ECM algorithm. Defaults to 0.001}

\item{max_iter}{The maximum number of iterations. Defaults to 1000}
}
\value{
Returns a list with elements M (the estimate of the location), A (the estimate of the skewness), nu (the estimate of the degrees of freedom), Sigma (the estimate of Sigma), Psi (the estimate of Psi), loglik (a vector of log likelihood values), flag (returns TRUE if a numerical issue occured, FALSE otherwise).
}
\description{
Performs paramter estimation for the matrix variate skew-t distribution using an ECM algorithm.
}
\examples{
data(SimX)
Fit_st<-Fit_Skewt(SimX)
}
