% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilMWRsheet.R
\name{utilMWRsheet}
\alias{utilMWRsheet}
\title{Format a list of QC tables for spreadsheet export}
\usage{
utilMWRsheet(datin, rawdata = TRUE)
}
\arguments{
\item{datin}{list of input QC tables}

\item{rawdata}{logical to include quality control accuracy summaries for raw data, e.g., field blanks, etc.}
}
\value{
A list similar to the input with formatting applied
}
\description{
Format a list of QC tables for spreadsheet export
}
\details{
The function is used internally with \code{\link{qcMWRreview}} to format data quality objective and quality control tables for export into an Excel spreadsheet.  These changes are specific to the spreadsheet format and may not reflect the formatting in the Word document produced by \code{\link{qcMWRreview}}.

The \code{datin} list is expected to contain the following elements:
\itemize{
\item \code{frecomdat} Data Quality Objectives for frequency and completeness data frame as returned by \code{\link{readMWRfrecom}}
\item \code{accdat} Data Quality Objectives for accuracy data frame as returned by \code{\link{readMWRacc}}
\item \code{tabfreper} Frequency checks percent table, created with \code{\link{tabMWRfre}}
\item \code{tabfresum} Frequency checks summary table, created with \code{\link{tabMWRfre}}
\item \code{tabaccper} Accuracy checks percent table, created with \code{\link{tabMWRacc}}
\item \code{tabaccsum} Accuracy checks summary table, created with \code{\link{tabMWRacc}}
\item \code{tabcom} Completeness table, created with \code{\link{tabMWRcom}}
\item \code{indflddup} Individual accuracy checks table for field duplicates, created with \code{\link{tabMWRacc}}, can be \code{NULL}
\item \code{indlabdup} Individual accuracy checks table for lab duplicates, created with \code{\link{tabMWRacc}}, can be \code{NULL}
\item \code{indfldblk} Individual accuracy checks table for field blanks, created with \code{\link{tabMWRacc}}, can be \code{NULL}
\item \code{indlabblk} Individual accuracy checks table for lab blanks, created with \code{\link{tabMWRacc}}, can be \code{NULL}
\item \code{indlabins} Individual accuracy checks table for lab spikes and instrument checks, created with \code{\link{tabMWRacc}}, can be \code{NULL}
}
}
\examples{
# results data path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# dqo accuracy data path
accpth <- system.file('extdata/ExampleDQOAccuracy.xlsx', package = 'MassWateR')

# dqo completeness data path
frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', package = 'MassWateR')

# censored data path
censpth <- system.file('extdata/ExampleCensored.xlsx', package = 'MassWateR')

# results data
resdat <- readMWRresults(respth)

# accuracy data
accdat <- readMWRacc(accpth)

# frequency and completeness data
frecomdat <- readMWRfrecom(frecompth)

# censored data
censdat <- readMWRcens(censpth)

# frequency table percent
tabfreper <- tabMWRfre(res = resdat, acc = accdat, frecom = frecomdat, type = 'percent', 
  warn = FALSE) 

# frequency summary table
tabfresum <- tabMWRfre(res = resdat, acc = accdat, frecom = frecomdat, type = 'summary', 
  warn = FALSE)

# accuracy table percent
tabaccper <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'percent', 
  warn = FALSE)

# accuracy table summary
tabaccsum <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'summary', 
  warn = FALSE)
  
# completeness table
tabcom <- tabMWRcom(res = resdat, frecom = frecomdat, cens = censdat, warn = FALSE, 
  parameterwd = 1.15, noteswd = 2)

# individual accuracy checks for raw data
indflddup <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'individual', 
  accchk = 'Field Duplicates', warn = FALSE, caption = FALSE)
indlabdup <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'individual', 
  accchk = 'Lab Duplicates', warn = FALSE, caption = FALSE)
indfldblk <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'individual', 
  accchk = 'Field Blanks', warn = FALSE, caption = FALSE)
indlabblk <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'individual', 
  accchk = 'Lab Blanks', warn = FALSE, caption = FALSE)
indlabins <- tabMWRacc(res = resdat, acc = accdat, frecom = frecomdat, type = 'individual', 
  accchk = 'Lab Spikes / Instrument Checks', warn = FALSE, caption = FALSE)

# input  
datin <- list(
  frecomdat = frecomdat, 
  accdat = accdat,
  tabfreper = tabfreper,
  tabfresum = tabfresum,
  tabaccper = tabaccper,
  tabaccsum = tabaccsum,
  tabcom = tabcom,
  indflddup = indflddup,
  indlabdup = indlabdup,
  indfldblk = indfldblk,
  indlabblk = indlabblk,
  indlabins = indlabins
)

utilMWRsheet(datin)
}
