% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tabMWRcom.R
\name{tabMWRcom}
\alias{tabMWRcom}
\title{Create a formatted table of quality control completeness checks}
\usage{
tabMWRcom(
  res = NULL,
  frecom = NULL,
  cens = NULL,
  fset = NULL,
  runchk = TRUE,
  warn = TRUE,
  pass_col = "#57C4AD",
  fail_col = "#DB4325",
  digits = 0,
  suffix = "\%",
  parameterwd = 1.15,
  noteswd = 3
)
}
\arguments{
\item{res}{character string of path to the results file or \code{data.frame} for results returned by \code{\link{readMWRresults}}}

\item{frecom}{character string of path to the data quality objectives file for frequency and completeness or \code{data.frame} returned by \code{\link{readMWRfrecom}}}

\item{cens}{character string of path to the censored data file or \code{data.frame} returned by \code{\link{readMWRcens}}, optional}

\item{fset}{optional list of inputs with elements named \code{res}, \code{acc}, \code{frecom}, \code{sit}, or \code{wqx} overrides the other arguments}

\item{runchk}{logical to run data checks with \code{\link{checkMWRresults}} and \code{\link{checkMWRfrecom}}, applies only if \code{res} or \code{frecom} are file paths}

\item{warn}{logical to return warnings to the console (default)}

\item{pass_col}{character string (as hex code) for the cell color of checks that pass}

\item{fail_col}{character string (as hex code) for the cell color of checks that fail}

\item{digits}{numeric indicating number of significant digits to report for percentages}

\item{suffix}{character string indicating suffix to append to percentage values}

\item{parameterwd}{numeric indicating width of the parameter column}

\item{noteswd}{numeric indicating width of notes column}
}
\value{
A \code{\link[flextable]{flextable}} object with formatted results showing summary counts for all completeness checks for each parameter.
}
\description{
Create a formatted table of quality control completeness checks
}
\details{
The function can be used with inputs as paths to the relevant files or as data frames returned by \code{\link{readMWRresults}}, \code{\link{readMWRfrecom}}, and \code{\link{readMWRcens}} (optional).  For the former, the full suite of data checks can be evaluated with \code{runkchk = T} (default) or suppressed with \code{runchk = F}, as explained in the relevant help files.  In the latter case, downstream analyses may not work if data are formatted incorrectly. For convenience, a named list with the input arguments as paths or data frames can be passed to the \code{fset} argument instead. See the help file for \code{\link{utilMWRinput}}.

Also note that completeness is only evaluated on parameters that are shared between the results file and data quality objectives file for frequency and completeness. A warning is returned for parameters that do not match between the files. A similar warning is returned if there are parameters in the censored data, if provided, that are not in the results file and vice versa. These warnings can be suppressed by setting \code{warn = FALSE}.

A summary table showing the number of data records, number of qualified records, and percent completeness is created.  The \code{\% Completeness} column shows cells as green or red if the required percentage of observations for completeness are present as specified in the data quality objectives file.  The \code{Hit/ Miss} column shows similar information but in text format, i.e., \code{MISS} is shown if the quality control standard for completeness is not met.

Inputs for the results and data quality objectives for frequency and completeness are processed internally with \code{\link{qcMWRcom}} and the same arguments are accepted for this function, in addition to others listed above.
}
\examples{
##
# using file paths

# results path
respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

# frequency and completeness path
frecompth <- system.file('extdata/ExampleDQOFrequencyCompleteness.xlsx', 
     package = 'MassWateR')
     
# censored path
censpth <- system.file('extdata/ExampleCensored.xlsx', package = 'MassWateR')

tabMWRcom(res = respth, frecom = frecompth, cens = censpth)

##
# using data frames

# results data
resdat <- readMWRresults(respth)

# frequency and completeness data
frecomdat <- readMWRfrecom(frecompth)

# censored data
censdat <- readMWRcens(censpth)

tabMWRcom(res = resdat, frecom = frecomdat, cens = censdat)

}
