% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hello.R
\name{calculate_FBI}
\alias{calculate_FBI}
\title{Assigned tolerancevalues range from 0 to 10 for families and increase as water quality decreases}
\usage{
calculate_FBI(
  data,
  tolerances = list(Capniidae = 1, Aeshnidae = 3, Chloroperlidae = 1, Calopterygidae = 5,
    Leuctridae = 0, Coenagrionidae = 9, Nemouridae = 2, Cordulegastridae = 3, Perlidae =
    1, Corduliidae = 5, Perlodidae = 2, Gomphidae = 1, Pteronarcyidae = 0, Lestidae = 9,
    Taeniopterygidae = 2, Libellulidae = 9, Macromiidae = 3, Baetidae = 4, Baetiscidae =
    3, Athericidae = 2, Caenidae = 7, Blephariceridae = 0, Ephemerellidae = 1,
    Ceratopogonidae = 6, Ephemeridae = 4, Chironomidae_red = 8, Heptageniidae = 4,
    Chironomidae_other = 6, 
     Leptophlebiidae = 2, Dolichopodidae = 4, Metrtopodidae
    = 2, Empididae = 6, Oligoneuriidae = 2, Ephydridae = 6, Polymitarcyidae = 2,
    Psychodidae = 10, Potamanthidae = 4, Simuliidae = 6, Siphlonuridae = 7, Muscidae = 6,
    Tricorythidae = 4, Syrphidae = 10, Tabanidae = 6, Pyralidae = 5, Tipulidae = 3,
    Brachycentridae = 1, Dryopidae = 5, Calamoceratidae = 3, Elmidae = 4, Glossosomatidae
    = 1, Psephenidae = 4, Helicopsychidae = 3, Hydropsychidae = 4, Gammaridae = 4,
    Hidroptilidae = 4, Hyalellidae = 8, 
     Lepidostomatidae = 1, Leptoceridae = 4,
    Asellidae = 8, Limnephilidae = 4, Molannidae = 6, Odontoceridae = 0, Astacidae = 6,
    Philopotamidae = 3, Phryganeidae = 4, Lymnaeidae = 6, Polycentropodidae = 6, Physidae
    = 8, Psychomyiidae = 2, Rhyacophilidae = 0, Pisidiidae = 8, Sericostomatidae = 3,
    Oligochaeta = 8, Uenoidae = 3, Hirudinea = 10, Turbellaria = 4, Corydalidae = 0,
    Sialidae = 4, Ameletidae = 0, Baetiscidae = 4, Isonychiidae = 2, Leptohyphidae = 4,
    Metretopodidae = 2, Potomanthidae = 4, Peltoperlidae = 0, 
     Corixidae = 5,
    Apataniidae = 3, Dipseudopsidae = 5, Goeridae = 3, Curculionidae = 5, Dytiscidae = 5,
    Gyrinidae = 4, Haliplidae = 5, Hydrophilidae = 5, Ptilodactylidae = 3, Scirtidae = 5,
    Sisyridae_Climacia_sp = 5, Anthomyiidae = 6, Chaoboridae = 8, Culicidae = 8, Dixidae
    = 1, Ptychopteridae = 1, Scathophagidae = 6, Stratiomyidae = 7, Tanyderidae = 3,
    Arrenuridae = 6, Lebertiidae = 6, Atractideidae = 6, Mideopsidae = 6, Tyrellidae = 6,
    Limnesidae = 6, Limnocharidae = 6, Sperchonidae = 6, Unionicolidae = 6, 
    
    Polydesmida = 6, Anthuridae = 5, Idoteidae = 5, Crangonyctidae = 6, Oedicerotidae =
    5, Talitridae_Hyalellidae = 8, Acariformes = 4, Ostracoda = 8, Planorbidae = 7,
    Ancylidae = 6, Viviparidae = 6, Pleuroceridae = 6, Bithyniidae = 8, Hydrobiidae = 6,
    Valvatidae = 8, Pelecypoda_Bivalvia = 8, Unionidae = 6, Corbiculidae = 6,
    Dreisseniidae = 8, Sphaeriidae = 6, Pisidiidae = 8, Haplotaxidae = 5, Lumbricida = 6,
    Lumbriculidae = 5, Enchytraeidae = 10, Tubificidae = 9, Naididae = 8,
    Glossiphoniidae_Helobdella = 6, 
     Glossiphoniidae_other = 8, Aeolosomatidae = 8,
    Branchiobdellidae = 6, Sabellidae = 6, Platyhelminthidae = 4),
  print_results = TRUE
)
}
\arguments{
\item{data}{For the families that we  have given the value for particular genera and you should add data like this : Sisyridae_Climacia_sp Talitridae_Hyalellidae, Pelecypoda_Bivalvia, Glossiphoniidae_Helobdella,Glossiphoniidae_other
Chironomidae_red, Chironomidae_other}

\item{tolerances}{tolerance value are given by default}

\item{print_results}{A logical value that determines whether or not to print the results. Defaults to TRUE.}
}
\value{
will give values from 0-10
}
\description{
Assigned tolerancevalues range from 0 to 10 for families and increase as water quality decreases
}
\examples{
Site= c("L1", "L2", "L2")
Family=c("Capniidae",  "Aeshnidae", "Chloroperlidae")
Abundance=c(4,2,15)
test <- data.frame( Family, Abundance, Site)
calculate_FBI(test)
}
\references{
1. Hilsenhoff, W.L. 1988. Rapid field assessment of organic pollution with a family- level biotic index. J. N. Am. Benthol. Soc. 7(1):65-68. Barbour, M.T., Gerritsen, J., Snyder,

2. Bode, R.W., Novak, M.A., and Abele, L.E. 1996. Quality Assurance Work Plan for Biological Stream Monitoring in New York State. NYS Department of Environmental Conservation, Albany, NY. 89p. 4 appendices.

3. Bode, R.W., Novak, M.A., Abele, L.E., Heitzman, D.L., and Smith, A.J. 2002. Quality Assurance Work Plan for Biological Stream Monitoring in New York State. NYS Department of Environmental Conservation, Albany, NY. 115p

4. Hauer, F.R., Lamberti, G.A. (eds.) 1996. Methods in Stream Ecology. Academic Press. ISBN: 0-12-332906-X. 696pp.

5.B.D., Stribling, J.B. 1999.Rapid BioassessmentProtocols For Use in Streams and Wadeable Rivers:Periphyton, BenthicMacroinvertebrates, and Fish. Second Edition. EPA 841-B-99-002. Washington, D.C. xiv, 11chapters,

6. Plafkin, J.L. , Barbour, M.T., Porter, K.D., Gross, S.K., and Hughes, R.M.. 1989. Rapid Bioassessment Protocols for use in Streams and Rivers: Benthic Macroinvertebrates and Fish. U.S. Environmental Protection Agency. EPA 440/4-  89/001. 8 chapters, Appendices A-D.
}
