\name{EPI}
\alias{EPI}
\docType{data}
\title{Wind power scenarios generated by epi-spline approximation}
\description{This data set provides 24-hour wind power scenarios, each with a different probability, and observations for 345 instances (days)}
\usage{data("EPI")}
\format{A list containing wind power scenarios for 345 days, where each day includes 27 scenarios, their corresponding probabilities, and one observation of dimension 24, representing hourly values.
}

\references{
[2]D. Sari, S.Ryan. Reliability of wind power scenarios and stochastic unit commitment cost. Under review. 
%%  ~~ possibly secondary sources and usages ~~
}
\examples{
data(EPI)
epi_ranks <- MTDrh(EPI$scen,EPI$obs,EPI$prob,FALSE,FALSE)

#with different probabilities;
s.prob<-array(rep(c(0.7,rep(0.3/26,times=26)),times=345),dim=c(27,345))
epi_ranks <- MTDrh(EPI$scen,EPI$obs,s.prob,FALSE,FALSE)
  
#or
s.prob2<-array(rep(c(0.35,rep(0.3/25,times=25),0.35),times=345),dim=c(27,345))
epi_ranks <- MTDrh(EPI$scen,EPI$obs,s.prob2,FALSE,FALSE)
  
}
\keyword{datasets}
