% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_quantiles_2.R
\name{compute_quantiles_2}
\alias{compute_quantiles_2}
\title{Computes quantiles of the gaussian multiscale statistics.}
\usage{
compute_quantiles_2(
  t_len,
  n_ts = 1,
  grid = NULL,
  ijset = NULL,
  sigma = 1,
  deriv_order = 0,
  sim_runs = 1000,
  probs = seq(0.5, 0.995, by = 0.005),
  correction = TRUE,
  epidem = FALSE,
  numCores = NULL
)
}
\arguments{
\item{t_len}{Sample size.}

\item{n_ts}{Number of time series analyzed. Default is 1.}

\item{grid}{Grid of location-bandwidth points as produced by
the function \code{\link{construct_grid}} or
\code{\link{construct_weekly_grid}}, list with
the elements 'gset', 'bws', 'gtype'. If not provided,
then the defalt grid is produced and used.
For the construction of the default grid,
see \code{\link{construct_grid}}.}

\item{ijset}{A matrix of integers. In case of multiple time series,
we need to know which pairwise comparisons to perform.
This matrix consists of all pairs of indices \eqn{(i, j)}
that we want to compare. If not provided, then all
possible pairwise comparison are performed.}

\item{sigma}{Value of \eqn{\sqrt{\sigma^2}}. In case of n_ts = 1,
\eqn{\sigma^2} denotes the long-run error variance, and
in case of n_ts > 1, \eqn{\sigma^2} denotes the
overdispersion parameter.
If not given, then the default is 1.}

\item{deriv_order}{In case of a single time series analysed, this parameter
denotes the order of the derivative of the trend
function that is being estimated. Default is 0.}

\item{sim_runs}{Number of simulation runs to produce quantiles.
Default is 1000.}

\item{probs}{A numeric vector of probability levels \eqn{(1-\alpha)}
for which the quantiles are computed.
Default is \eqn{(0.5, 0.505, 0.51, \ldots, 0.995)}.}

\item{correction}{Logical variable, TRUE (by default) if we are using
\eqn{a_k} and \eqn{b_k}.}

\item{epidem}{Logical variable, TRUE if we are using
dealing with epidemic time trends. Default is FALSE.}

\item{numCores}{Integer value used to indicate how many cores are used
while calculating the critical value. Default is NULL,
then the formula used is
\code{round(detectCores() * .70)}.}
}
\value{
Matrix with 2 rows where the first row contains
                    the vector of probabilities (probs) and the second
                    contains corresponding quantiles of the gaussian
                    statistics distribution.
}
\description{
Quantiles from the gaussian version of the test
                    statistics which are used to approximate
                    the critical values for the multiscale test.
}
\examples{
compute_quantiles_2(100, numCores = 2)
}
