% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/eval_part2.r
\name{model_evaluation}
\alias{model_evaluation}
\title{model_evaluation function}
\usage{
model_evaluation(dat, mv, tn, prev, pthreshold = 0.05, method = "R2ROC")
}
\arguments{
\item{dat}{This is the dataframe for all the combinations of the model in a matrix format}

\item{mv}{The total number of columns in data_train/data_valid}

\item{tn}{The total number of best models to be identified}

\item{prev}{The prevalence of disease in the data}

\item{pthreshold}{The significance p value threshold when comparing models (default 0.05)}

\item{method}{The methods to be used to evaluate models (e.g. R2ROC (default) or r2redux)}
}
\value{
This function will generate all possible model outcomes for validation and test dataset
}
\description{
This function will identify the best model in the validation and test dataset.
}
\examples{
\donttest{
dat <- predict_validation
mv=8
tn=15
prev=0.047
out=model_evaluation(dat,mv,tn,prev)
#This process will generate three output files.
#out$out_all, contains AUC, p values for AUC, R2, and p values for R2, 
#respectively for all models.
#out$out_start, contains AUC, p values for AUC, R2, and p values for R2,
#respectively for top tn models.
#out$out_selected, contains AUC, p values for AUC, R2, and p values for R2,
#respectively for best models.  This also includes selected features for models
#For details (see https://github.com/mommy003/MSML).
}
}
\keyword{Identify}
\keyword{best}
\keyword{models}
