% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MSG-package.R
\docType{data}
\name{BinormCircle}
\alias{BinormCircle}
\title{Random numbers containing a ``circle''}
\format{
A data frame with 20000 observations on the following 2 variables.
  \describe{ \item{V1}{the first random variable with the x-axis coordinate
  of the circle} \item{V2}{the second random variable with the y-axis
  coordinate of the circle} }
}
\source{
\url{https://yihui.org/en/2008/09/to-see-a-circle-in-a-pile-of-sand/}
}
\description{
The data was generated from two independent random varialbes (standard Normal
distribution) and further points on a circle were added to the data. The
order of the data was randomized.
}
\details{
See the example section for the code to generate the data.
}
\examples{
data(BinormCircle)

## original plot: cannot see anything
plot(BinormCircle)

## transparent colors (alpha = 0.1)
plot(BinormCircle, col = rgb(0, 0, 0, 0.1))

## set axes lmits
plot(BinormCircle, xlim = c(-1, 1), ylim = c(-1, 1))

## small symbols
plot(BinormCircle, pch = ".")

## subset
plot(BinormCircle[sample(nrow(BinormCircle), 1000), ])

## 2D density estimation
library(KernSmooth)
fit = bkde2D(as.matrix(BinormCircle), dpik(as.matrix(BinormCircle)))
# perspective plot by persp()
persp(fit$x1, fit$x2, fit$fhat)

if (interactive() && require("rgl")) {
    # perspective plot by OpenGL
    rgl.surface(fit$x1, fit$x2, fit$fhat)
    # animation
    M = par3d("userMatrix")
    play3d(par3dinterp(userMatrix = list(M, rotate3d(M, pi/2, 1, 0, 0), rotate3d(M,
        pi/2, 0, 1, 0), rotate3d(M, pi, 0, 0, 1))), duration = 20)
}

## data generation
x1 = rnorm(10000)
y1 = rnorm(10000)
x2 = rep(0.5 * cos(seq(0, 2 * pi, length = 500)), 20)
y2 = rep(0.5 * sin(seq(0, 2 * pi, length = 500)), 20)
x = cbind(c(x1, x2), c(y1, y2))
BinormCircle = as.data.frame(round(x[sample(20000), ], 3))
}
