% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcee_helper_nuisance_config.R
\name{mcee_config_glm}
\alias{mcee_config_glm}
\title{Configure GLM for MCEE nuisance parameters}
\usage{
mcee_config_glm(target, formula, family = NULL, clipping = NULL)
}
\arguments{
\item{target}{Character. Nuisance parameter name ("p", "q", "eta", "mu", "nu").}

\item{formula}{RHS-only formula (e.g., \code{~ X1 + X2 + poly(time, 2)}).}

\item{family}{Optional GLM family. Defaults to \code{binomial()} for "p"/"q",
\code{gaussian()} for "eta"/"mu"/"nu".}

\item{clipping}{Optional numeric vector \code{c(lo, hi)} to clip predictions
into [lo, hi] for numerical stability.}
}
\value{
A configuration list for use with \code{\link{mcee_general}}.
}
\description{
Creates a configuration to fit nuisance parameters using generalized linear models
via \code{stats::glm()}.
}
\examples{
# Binary outcome model for propensity
cfg_q <- mcee_config_glm("q", ~ dp + M, family = binomial())

# Gaussian outcome model
cfg_eta <- mcee_config_glm("eta", ~ dp + X1)
}
