% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/d_dep_t_rm.R
\name{d_dep_t_rm}
\alias{d_dep_t_rm}
\title{Cohen's d for Paired t Controlling for Correlation (Repeated Measures)}
\usage{
d_dep_t_rm(m1, m2, sd1, sd2, r, n, a = 0.05)
}
\arguments{
\item{m1}{Mean from the first level/occasion.}

\item{m2}{Mean from the second level/occasion.}

\item{sd1}{Standard deviation from the first level/occasion.}

\item{sd2}{Standard deviation from the second level/occasion.}

\item{r}{Correlation between the two levels/occasions.}

\item{n}{Sample size (number of paired observations).}

\item{a}{Significance level (alpha) for the confidence interval.
Must be in (0, 1).}
}
\value{
A list with the following elements:
\describe{
  \item{d}{Cohen's \eqn{d_{rm}}.}
  \item{dlow}{Lower limit of the \eqn{(1-\alpha)} confidence interval
for \eqn{d_{rm}}.}
  \item{dhigh}{Upper limit of the \eqn{(1-\alpha)} confidence interval
for \eqn{d_{rm}}.}
  \item{M1, M2}{Group means.}
  \item{M1low, M1high, M2low, M2high}{Confidence interval bounds for
each mean.}
  \item{sd1, sd2}{Standard deviations.}
  \item{se1, se2}{Standard errors of the means.}
  \item{r}{Correlation between occasions.}
  \item{n}{Sample size.}
  \item{df}{Degrees of freedom (\eqn{n - 1}).}
  \item{estimate}{APA-style formatted string for reporting
\eqn{d_{rm}} and its CI.}
}
}
\description{
Compute Cohen's \eqn{d_{rm}} and a noncentral-t confidence interval for
repeated-measures (paired-samples) designs **controlling for the correlation
between occasions**. The denominator uses the SDs and their correlation.
}
\details{
The effect size is defined as:
\deqn{d_{rm} = \frac{m_1 - m_2}{\sqrt{s_1^2 + s_2^2 - 2 r s_1 s_2}} \;
\sqrt{2(1-r)}.}

The test statistic used for the noncentral-t confidence interval is:
\deqn{t = \frac{m_1 - m_2}{\sqrt{\dfrac{s_1^2 + s_2^2 - 2 r s_1 s_2}{n}}} \;
 \sqrt{2(1-r)}.}

See the online example for additional context:
\href{https://www.aggieerin.com/shiny-server/tests/deptrm.html}{Learn more on our example page.}
}
\examples{
# Example derived from the "dept_data" dataset included in MOTE

    t.test(dept_data$before, dept_data$after, paired = TRUE)

    scifi_cor <- cor(dept_data$before, dept_data$after, method = "pearson",
                     use = "pairwise.complete.obs")

# Direct entry of summary statistics, or refer to the dataset as shown below.

    d_dep_t_rm(m1 = 5.57, m2 = 4.43, sd1 = 1.99,
               sd2 = 2.88, r = .68, n = 7, a = .05)

    d_dep_t_rm(5.57, 4.43, 1.99, 2.88, .68, 7, .05)

    d_dep_t_rm(mean(dept_data$before), mean(dept_data$after),
               sd(dept_data$before), sd(dept_data$after),
               scifi_cor, length(dept_data$before), .05)
}
\keyword{cohen's}
\keyword{correlation}
\keyword{d}
\keyword{dependent}
\keyword{effect}
\keyword{measures}
\keyword{paired-sample}
\keyword{repeated}
\keyword{size}
\keyword{t-test}
