% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{attach_wfpc}
\alias{attach_wfpc}
\title{Attach Weighted Functional Principal Components to the Data}
\usage{
attach_wfpc(
  mfpca,
  data,
  n = NULL,
  obstime = "obstime",
  marker = "marker",
  eval_weight = FALSE
)
}
\arguments{
\item{mfpca}{MFPCA object from which to extract the weighted FPCS.}

\item{data}{Data set to which the weighted FPCS are to be attached.}

\item{n}{Number of FPCs to attach. Defaults to NULL which corresponds to all
FPCs in mfpc.}

\item{obstime}{Name of the time variable in data set at which points to
evaluate.}

\item{marker}{Name of the marker variable in the data set which separates the
data.}

\item{eval_weight}{Weight the FPC by the square root of its eigenvalue (then
variance comparable throughout all FPCs). Defaults to FALSE.}
}
\value{
Data set supplied as argument \code{data} with additional columns
 corresponding to the evaluations of the MFPC basis.
}
\description{
Attach Weighted Functional Principal Components to the Data
}
\examples{
# Small example based on subset of PBC data
data(pbc_subset)

# Estimate MFPC basis and attach to data
mfpca <- preproc_MFPCA(pbc_subset, uni_mean = paste0(
    "logy ~ 1 + sex + drug + s(obstime, k = 5, bs = 'ps') + ",
    "s(age, k = 5, bs = 'ps')"),
    pve_uni = 0.99, nbasis = 5, weights = TRUE, save_uniFPCA = TRUE)
pbc_subset <- attach_wfpc(mfpca, pbc_subset, n = 2)
}
