% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cube-CRISPR2X.R
\name{cubeXHomingDeposition}
\alias{cubeXHomingDeposition}
\title{Inheritance Cube: CRISPR (Clustered Regularly Interspaced Short Palindromic Repeats) X-linked with 2 Resistance Allele and Maternal Deposition}
\usage{
cubeXHomingDeposition(
  cF = 1,
  chF = 0,
  crF = 0,
  dF = 0,
  dhF = 0,
  drF = 0,
  eta = NULL,
  phi = NULL,
  omega = NULL,
  xiF = NULL,
  xiM = NULL,
  s = NULL
)
}
\arguments{
\item{cF}{Female cutting rate}

\item{chF}{Female proper homing rate}

\item{crF}{Female no-cost resistance generation rate}

\item{dF}{Female deposition cutting rate}

\item{dhF}{Female deposition proper homing rate}

\item{drF}{Female deposition no-cost resistance generation rate}

\item{eta}{Genotype-specific mating fitness}

\item{phi}{Genotype-specific sex ratio at emergence}

\item{omega}{Genotype-specific multiplicative modifier of adult mortality}

\item{xiF}{Genotype-specific female pupatory success}

\item{xiM}{Genotype-specific male pupatory success}

\item{s}{Genotype-specific fractional reduction(increase) in fertility}
}
\value{
Named list containing the inheritance cube, transition matrix, genotypes, wild-type allele,
and all genotype-specific parameters.
}
\description{
This is an X-linked version of the 2 allele cube. It assumes that the construct
is on the X chromosome and there is no male homing. It also has maternal deposition,
i.e., when the male provides a W allele to a female with an H allele, some portion
are cut during oogenesis.
If the deposition parameters are zero (*D parameters), this is just
an X-linked drive.
}
