% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate.R
\name{evaluate}
\alias{evaluate}
\title{Compute error metrics for predicted values or prediction matrices}
\usage{
evaluate(predicted, actual)
}
\arguments{
\item{predicted}{numeric vector or numeric matrix of predictions. If matrix, columns are evaluated
separately.}

\item{actual}{numeric vector of true target values.}
}
\value{
A data frame with columns MAE, RMSE, MAPE, SMAPE, MSE, and MedAE, with one row
per evaluated prediction vector.
}
\description{
Compute error metrics for predicted values or prediction matrices by comparing them with
the corresponding true response values.
}
\details{
The evaluate function is used to quantify the predictive performance of meta fuzzy function
predictions by comparing them with the corresponding true response values. It supports both
vector- and matrix-valued prediction inputs, allowing performance assessment of a single
meta fuzzy function as well as simultaneous evaluation of multiple meta fuzzy functions.
When a prediction vector is provided, the function computes a single set of performance
metrics; when a prediction matrix is provided, metrics are computed separately for each meta
fuzzy function.
}
\examples{
x <- seq(100)
y <- 2*x + stats::rnorm(100)
m <- stats::lm(y ~ x)
pred <- stats::predict(m)
evaluate(pred, y)

}
\seealso{
\code{\link{mff}} for generating predictions,
\code{\link{model.train}} for preparing base model prediction matrices,
\code{\link{tune.mff}} for hyperparameter tuning performance.
}
