% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/est_FM.R
\name{est_FM}
\alias{est_FM}
\title{Estimation of factor models on matrix time series}
\usage{
est_FM(Yt, r = 0, delta = 0.2)
}
\arguments{
\item{Yt}{demeaned matrix time series, written in an array with dimension 3 and the first dimension for time.}

\item{r}{Rank of core factors for the common component, written in a vector of length 2. First value as 0 is to denote unknown rank which would be automatically estimated using ratio-based estimators. Default is 0.}

\item{delta}{Non-negative number as the correction parameter for rank estimation. Default is 0.2.}
}
\value{
A list containing the following:
r: a vector representing either the given rank or the estimated rank, with length 2;
A: a list of the estimated row and column factor loading matrices;
Ft: the estimated core factor series, as multi-dimensional array with dimension 3, where mode-1 is the time mode;
Ct: the estimated common component time series, as multi-dimensional array with dimension 3, where mode-1 is the time mode;
covMatrix: a list of the estimated row and column covariance matrices which are used to estimate loading matrices;
}
\description{
Estimate the FM structure on the given matrix time series
}
\examples{
TT = 40;
d = c(40,40);
r = c(2,2);
re = c(2,2);
eta = list(c(0,0), c(0,0));
coef_f = c(0.7, 0.3, -0.4, 0.2, -0.1);
coef_fe = c(-0.7, -0.3, -0.4, 0.2, 0.1);
coef_e = c(0.8, 0.4, -0.4, 0.2, -0.1);
param_mu = c(0,1);
param_alpha = c(0,1);
param_beta = c(0,1);
data_example = gen_MEFM(TT,d,r,re,eta, coef_f, coef_fe, coef_e, param_mu, param_alpha, param_beta);
est_FM(data_example$FM);


}
