# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Generates the row indices used internally to generate the sparse matrix A.
#'
#' @param bS A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.
#' @param M A vector of positive integers giving the alphabet sizes of the discrete variables.
#' @return A vector of row indices.
aMatrixSparseRevLex <- function(bS, M) {
    .Call('_MCARtest_aMatrixSparseRevLex', PACKAGE = 'MCARtest', bS, M)
}

#' Calculates the total cardinality of the sample spaces.
#'
#' @param bS A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.
#' @param M A vector of positive integers giving the alphabet sizes of the discrete variables.
#' @return The total cardinality.
infoS <- function(bS, M) {
    .Call('_MCARtest_infoS', PACKAGE = 'MCARtest', bS, M)
}

#' Calculates the individual cardinalities of the sample spaces.
#'
#' @param bS A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.
#' @param M A vector of positive integers giving the alphabet sizes of the discrete variables.
#' @return A vector of individual cardinalities.
infoS2 <- function(bS, M) {
    .Call('_MCARtest_infoS2', PACKAGE = 'MCARtest', bS, M)
}

#' Generates the column indices used internally to generate the sparse matrix A.
#'
#' @param cardS The number of missingness patterns.
#' @param cardChi The cardinality of the full joint space.
#' @return A vector of column indices.
colVector <- function(cardS, cardChi) {
    .Call('_MCARtest_colVector', PACKAGE = 'MCARtest', cardS, cardChi)
}

#' Internal function multiplying a mass function by the sparse matrix A.
#' 
#' @param p A subprobability mass function on the full joint space.
#' @param bS A binary matrix specifying the set of observation patterns. Each row encodes a single pattern.
#' @param M A vector of positive integers giving the alphabet sizes of the discrete variables.
#' @return A collection of marginal mass functions.
margProj <- function(p, bS, M) {
    .Call('_MCARtest_margProj', PACKAGE = 'MCARtest', p, bS, M)
}

