% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export-ObservationCounts.R
\name{plot_counts_2D}
\alias{plot_counts_2D}
\title{Plot counts of observations across two dimensions, optionally stratified}
\usage{
plot_counts_2D(
  data,
  x,
  y,
  stratify_by = NULL,
  for_each = NULL,
  color_gradient = c("blue", "beige", "red"),
  title = "Observation counts",
  legend_title = NULL,
  subtitle = NULL,
  x_lab = NULL,
  y_lab = NULL
)
}
\arguments{
\item{data}{Data frame containing all input variables.}

\item{x}{Variable in \code{data} whose values define the x-axis for counts.}

\item{y}{Variable in \code{data} whose values define the y-axis for counts.}

\item{stratify_by}{(Optional) Stratification variable. If
supplied, counts are computed for each combination of \code{x}, \code{y} and
\code{stratify_by}, and separate heatmaps are generated per level of \code{stratify_by}.}

\item{for_each}{(Optional) Additional stratification variable. If supplied,
separate plot windows are created per level of \code{for_each}.}

\item{color_gradient}{(Optional) Color gradient for the heatmap. Specified as a character vector of three colors, representing: c(<low_counts>, <middle_counts>, <high_counts>).
Defaults to \code{c("blue", "beige", "red")}. Colors must be recognized by \code{\link[ggplot2]{ggplot}}.}

\item{title}{(Optional) Plot title; defaults to \code{"Observation counts"}.}

\item{legend_title}{(Optional) Legend title for color gradient; defaults to "Count".}

\item{subtitle}{(Optional) Plot subtitle; defaults to \code{NULL} if for \code{for_each} is \code{NULL},
defaults to \code{<name of for_each>: <level of for_each>} for each plot window if \code{for_each} is supplied.}

\item{x_lab}{(Optional) Label for the x-axis; defaults to the name of \code{x}.}

\item{y_lab}{(Optional) Label for the y-axis; defaults to the name of \code{y}.}
}
\value{
If \code{for_each} is not supplied, a \link[ggplot2]{ggplot} object
showing a heatmap of counts for each \code{x}-\code{y} combination, optionally
faceted by \code{stratify_by}. If \code{for_each} is supplied, a named list
of such \code{ggplot} objects, one per unique value of \code{for_each}.
}
\description{
Computes the number of observations for each combination of two specified
variables, and displays the result as a heatmap using \pkg{ggplot2}. If a stratification variable
is provided, counts are calculated per strata and strata-specific heatmaps are displayed in individual panels.
If an additional stratification variable is provided, separate plot windows are created for each level.
}
\examples{
data("toy_data")
# Heatmap of counts by age and period
plot_counts_2D(toy_data, x = age, y = period)
# Heatmap of counts by age and period, stratified by education
plot_counts_2D(toy_data, x = period, y = age,
               stratify_by = education)
# Heatmap of counts by age and period, stratified by education, for each sex
plot_counts_2D(toy_data, x = period, y = age,
               stratify_by = education, for_each = sex)
}
\seealso{
\code{\link{plot_counts_1D}}, \code{\link{plot_binned_counts}},
\code{\link{plot_counts_with_mean}}, \code{\link[ggplot2]{ggplot}}
}
