% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unanchored_kmplot.R
\name{unanchored_kmplot}
\alias{unanchored_kmplot}
\title{Generate a Kaplan-Meier Plot with Individual Efficacy Data and Pseudo
Efficacy Data.}
\arguments{
\item{unds_wts}{A combined data frame containing individual efficacy data
from the intervention study and pseudo efficacy data from the comparator
study.}

\item{unds.arm}{The name of the grouping column in the combined data frame
specified by \emph{unds_wts}, e.g., comparator.arm = TRT. The default is TRT.}

\item{unds.param.var}{The name of the column that specifies only a subset
of the rows of the data to be used.}

\item{unds.param}{A character specifying the subset of the rows to be used.
This is the value of the column set by the \emph{unds.param.var}.}

\item{time}{The name of the survival or follow up time column in the
combined data frame.}

\item{status}{The status indicator, normally 0 = event, 1 = censored. Can
be reseted using the \emph{event} parameter.}

\item{event}{A numeric value that represents the survival status, 0 = event,
1 = censored.}

\item{wt.col}{The name of the estimated weights column in the data frame
specified by \emph{unds_wts}. The default is wt.}

\item{km.xlim}{A numeric value specifying the right limit of the scale on
the X-axis.}

\item{xstepby}{An integer guiding the breaks on the X-axis.}

\item{km.ylim}{A numeric value specifying the upper limit of the scale on
the Y-axis.}

\item{ystepby}{An integer guiding the breaks on the Y-axis.}

\item{xlab}{A character giving label of the X-axis. The default is
"Time (Months)".}

\item{ylab}{A character giving label of the Y-axis. The default is
"Survival probability".}

\item{km.legend}{A character vector of length >=1 to appear in the legend.}

\item{km.title}{A character used to set the main title at the top.}

\item{...}{Refer to \link[survminer:ggsurvplot]{ggsurvplot} for additional
parameters..}
}
\value{
A Kaplan-Meier plot object that contains individual efficacy data
from the intervention study and pseudo efficacy data from the comparator
study.
}
\description{
Generate a Kaplan-Meier Plot with Individual Efficacy Data and Pseudo
Efficacy Data.
}
\examples{
\donttest{
unanchored_kmplot(
  unds_wts = unpts, unds.arm = ARM,
  unds.param.var = PARAMCD, unds.param = "OS",
  time = AVAL, status = CNSR, event = 0,
  wt.col = wt, km.xlim = 35, xstepby = 3,
  km.legend = c("Arm A", "ARM B"),
  km.title = "AAAA")
}

}
