% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_H.R
\name{update_H}
\alias{update_H}
\title{Update sub-matrices list Hi}
\usage{
update_H(WL, init_list)
}
\arguments{
\item{WL}{a list of multiple modality data matrices}

\item{init_list}{a list of the initialized modality specific sub-matrices list Hi and shared sub-matrix E}
}
\value{
update_H_list, the data list init_list with the modality specific sub-matrices list Hi updated.
}
\description{
Update sub-matrices list Hi
}
\examples{
library(InterSIM)
sim.data <- InterSIM(n.sample=500, cluster.sample.prop = c(0.20,0.30,0.27,0.23),
delta.methyl=5, delta.expr=5, delta.protein=5,p.DMP=0.2, p.DEG=NULL,
p.DEP=NULL,sigma.methyl=NULL, sigma.expr=NULL, sigma.protein=NULL,cor.methyl.expr=NULL,
cor.expr.protein=NULL,do.plot=FALSE, sample.cluster=TRUE, feature.cluster=TRUE)
sim.methyl <- sim.data$dat.methyl
sim.expr <- sim.data$dat.expr
sim.protein <- sim.data$dat.protein
temp_data <- list(sim.methyl, sim.expr, sim.protein)
init_list <- initialize_WL(temp_data,k=4)
update_H_list <- update_H(temp_data,init_list)
}
