% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/further_functions.R
\name{sort_loop_index}
\alias{sort_loop_index}
\title{Sort loop indices}
\usage{
sort_loop_index(loop_list)
}
\arguments{
\item{loop_list}{Dataframe with a column \code{loop} that contains the lists
of loops, e.g. obtained from \code{find_loops()}.}
}
\description{
Changes the loop representation such that every loop starts with the
smallest node index. Returns a loop list of the same dimensions, only
column \code{loop} will be altered.
}
\examples{
#sample Jacobian matrix of a system with 4 variables
jac_matrix <- rbind(c(-1,0,0,-1),c(1,-1,0,1),c(0,1,-1,0),c(0,0,1,-1))
#find the feedback loops of the system
loop_list <- find_loops(jac_matrix,10)
#sort the loop indices to start with the smallest
sorted_loop_list <- sort_loop_index(loop_list)

}
\seealso{
\code{\link{compare_loop_list}}
}
