\name{decom_results}
\alias{decom_results}
\docType{data}
\title{
  Decomposition Results Comparing Two Populations
}
\description{
  Decomposition results obtained from the \code{Decomp_sullivan()} function. This object includes age-cause-specific mortality, disability, and total effects to differences in cohort health expectancy (HE).
}
\usage{data(decom_results)}
\format{
  A list with the following components:
    \describe{
      \item{\code{mortality_effect}}{A matrix with rows representing total, background, and causes (e.g., Z1, Z2, Z3), and columns representing age groups. Each cell indicates the contribution of a given cause to the mortality effect on health expectancy differences.}
      \item{\code{disability_effect}}{A matrix structured as above, representing contributions to the disability effect.}
      \item{\code{total_effect}}{A matrix summing the mortality and disability effects for each cause at each age.}
      \item{\code{population1_HE}}{Numeric value of cohort health expectancy (HE) in population 1.}
      \item{\code{population2_HE}}{Numeric value of cohort health expectancy (HE) in population 2.}
      \item{\code{population1_LE}}{Numeric value of cohort life expectancy (LE) in population 1.}
      \item{\code{population2_LE}}{Numeric value of cohort life expectancy (LE) in population 2.}
      \item{\code{var_list}}{A character vector of cause names (e.g., \code{c("Z1", "Z2", "Z3")}).}
      \item{\code{time_list}}{An integer vector indicating age groups.}
      \item{\code{copula}}{A string indicating the method used for decomposition, e.g., \code{"Decomposition_sullivan"}.}
    }
}
\source{
  Generated for the manuscript:\cr
  Tao Sun, Huiping Zheng, and Xiaojun Wang (2025+).\cr
  \emph{Decomposing Differences in Cohort Health Expectancy by Cause and Age with Longitudinal Data}.
}
\examples{
  data(decom_results)
  str(decom_results)
}
\keyword{datasets}
