% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.logforest.R
\name{print.logforest}
\alias{print.logforest}
\title{Print Method for Logic Forest Models}
\usage{
\method{print}{logforest}(x, sortby = "importance", ...)
}
\arguments{
\item{x}{An object of class \code{"logforest"}.}

\item{sortby}{Character string specifying whether to sort the output by \code{"importance"}
(default) or \code{"frequency"}.}

\item{...}{Additional arguments (currently ignored).}
}
\value{
No return value. This function is called for its side effect of printing.
}
\description{
Prints the most important predictors and interactions from a fitted logic forest model,
along with their importance scores and frequency of occurrence.
}
\details{
This method displays a matrix of the top predictors and interactions from a logic forest model.
If \code{x$norm = TRUE}, the variable importance scores are normalized such that the largest
score is 1 and all other scores are scaled accordingly.
}
\seealso{
\code{\link{logforest}}
}
\author{
Bethany Wolf \email{wolfb@musc.edu}
}
