% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/build.interactions.R
\name{build.interactions}
\alias{build.interactions}
\title{Building Interactions}
\usage{
build.interactions(
  fit,
  test.data,
  n_ints = NULL,
  remove_negated = FALSE,
  req_frequency = NULL
)
}
\arguments{
\item{fit}{Fitted logic regression tree object containing outcome, model type, and logic tree information.}

\item{test.data}{Any dataset that contains the variables to create the interactions}

\item{n_ints}{Max number of interactions to build}

\item{remove_negated}{Whether to build interactions that consist of only negated PIs (True/False)}

\item{req_frequency}{Minimum frequency required to build interaction (0-1)}
}
\value{
A dataframe containing the the input dataframe and the interactions built from logic forest.
}
\description{
Builds interactions found from logic forest fit
}
\details{
This function creates the interactions in the data that are found via logic forest.
}
\references{
Wolf BJ, Hill EG, Slate EH. Logic Forest: an ensemble classifier for discovering logical combinations of binary markers.
\emph{Bioinformatics}. 2010;26(17):2183–2189. \doi{10.1093/bioinformatics/btq354}
}
\seealso{
\code{\link{logforest}}
}
\author{
Andrew Gothard \email{andrew.gothard@osumc.edu}
}
