#' Find Complement of a Logic Regression Tree
#'
#' Constructs the complement of a given logic regression tree and computes
#' the complement of its prime interactions (PIs).
#'
#' @details
#' This is an internal function called by \code{pimp.import} and is not intended
#' for independent use. It generates a new \code{"logregtree"} object where the
#' complements of the original tree's structure and PIs are calculated.
#'
#' @param tree An object of class \code{"logregtree"} representing the original logic tree.
#'
#' @return An object of class \code{"logregtree"} that is the complement of \code{tree}.
#' 
#' @author
#' Bethany Wolf \email{wolfb@@musc.edu}
#'
#' @keywords internal
find.ctree<-function(tree)
{
  conc<-ifelse(tree$trees$conc==3, 3, ifelse(tree$trees$conc==0, 0, 3-tree$trees$conc))
  neg<-ifelse(tree$trees$conc==3, 1-tree$trees$neg, 0)
  ctrees<-cbind(tree$trees$number, conc, tree$trees$knot, neg, tree$trees$pick)
  colnames(ctrees)<-c("number","conc","knot","neg","pick")
  ctrees<-as.data.frame(ctrees)
  ctree<-list(whichtree=tree$whichtree, coef=tree$coef, trees=ctrees)
  class(ctree)<-"logregtree"
  return(ctree)
}
