% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/train.peaksplines.R
\name{getOptimalSpline}
\alias{getOptimalSpline}
\title{Extract the optimal spline model parameters from the ModelSelection Object.}
\usage{
getOptimalSpline(
  lobraModelSelectionObject,
  qualityMeasure = "AIC",
  summeryfun = stats::median
)
}
\arguments{
\item{lobraModelSelectionObject}{LDOmodelselection created by the 'lobraModelSelection' function. It stores all evaluated Spline models to chose from.}

\item{qualityMeasure}{Quality measure to be used to select the optimal spline.}

\item{summeryfun}{Define the Summery function to be used. Default value is set to stats::median. Other possible functions would be mean, for instance.}
}
\value{
The function returns a 'lobraModelSelectionObject' that contains the optimal model according to the specified quality measure. @seealso plot.modelSelectionEvaluation
}
\description{
The method calculates which spline model and parameters worked best with respect to the median of the specified quality measure. The median is calculated among all component models.
}
\examples{
\dontrun{
} 
  data(LoBraExample)
  selectedLDO <- selectComponents(ldo, components)
  potentialBreaks=c(8, 12)
  nknots=c(1, 2)
  qualityMeasure=c("AIC", "BIC")
  ldoSelect<- lobraModelSelection(selectedLDO, potentialBreaks, nknots, qualityMeasure)
  
  optimalAIC<-getOptimalSpline(ldoSelect, qualityMeasure="AIC", summeryfun=stats::median)
  message(optimalAIC@breaks);
  
  optimalBIC<-getOptimalSpline(ldoSelect, qualityMeasure="BIC", summeryfun=base::mean)
  hist(unlist(optimalBIC@quality));

}
