% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_save_search.R
\name{create_save_search}
\alias{create_save_search}
\title{Creates and saves search string(s).}
\usage{
create_save_search(
  wos = FALSE,
  scp = FALSE,
  pmd = FALSE,
  directory,
  dry_run = FALSE
)
}
\arguments{
\item{wos}{Runs the search on Web of Science (TRUE or FALSE).}

\item{scp}{Runs the search on Scopus (TRUE or FALSE).}

\item{pmd}{Runs the search on PubMed (TRUE or FALSE).}

\item{directory}{Choose the directory in which the search string
and the search history will be saved.}

\item{dry_run}{Simulation run option.}
}
\value{
\code{NULL} (invisibly). Called for its side effects:
interactive querying and writing search history files.
}
\description{
An interactive function that
ask the user to enter a search string and provide
the number of results from 3 platforms:
Web of Science, Scopus and PubMed. You can then save one
or more search strings to retrieve the references later.
}
\examples{
# This is a "dry run" example.
# No search will be created and no database will be accessed.
# It only shows how the function should react.
create_save_search(wos = TRUE,
                   scp = TRUE,
                   pmd = TRUE,
                   directory,
                   dry_run = TRUE)

}
