##' Functions to Explore L-Systems (Lindenmayer Systems)
##' 
##' Lindenmayer or L-systems are parallel rewriting systems
##' which can be used to simulate biological forms and certain
##' kinds of fractals.  Briefly, in an L-system a series of
##' symbols in a string are replaced iteratively according to
##' rules to give a more complex string. Eventually, the
##' symbols are translated into turtle
##' graphics for plotting.  Wikipedia has a very good
##' introduction: \url{https://en.wikipedia.org/wiki/L-system}
##' This package provides basic functions for exploring L-systems.
##'
##' @name LindenmayeR-package
##' @aliases LindenmayeR
##' @title Lindenmayer System Functions
##' @docType package
##' @author Bryan A. Hanson
##' @import stringr
##' @import grid
##' @rdname LindenmayeR-package
##' @keywords package
NULL
