% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean_daily.R
\name{mean_daily_metric}
\alias{mean_daily_metric}
\title{Calculate mean daily metrics from Time Series}
\usage{
mean_daily_metric(
  data,
  Variable,
  Weekend.type = Date,
  Datetime.colname = Datetime,
  metric_type = duration_above_threshold,
  prefix = "average_",
  filter.empty = FALSE,
  Datetime2Time = TRUE,
  ...
)
}
\arguments{
\item{data}{A dataframe containing light logger data imported with LightLogR}

\item{Variable}{The variable column to analyze. Expects a \code{symbol}. Needs to
be part of the dataset.}

\item{Weekend.type}{A (new) column in the dataframe that specifies the day of
the week as a factor}

\item{Datetime.colname}{Column name containing datetime values. Defaults to
\code{Datetime}}

\item{metric_type}{The metric function to apply, default is
\code{\link[=duration_above_threshold]{duration_above_threshold()}}}

\item{prefix}{String that is the prefix on summarized values}

\item{filter.empty}{Filter out empty rows. Default is FALSE}

\item{Datetime2Time}{Logical of whether POSIXct columns should be transformed
into hms(time) columns, which is usually sensible for averaging (default is
\code{TRUE}). Calls \code{\link[=Datetime2Time]{Datetime2Time()}} with default settings (all POSIXct are
affected).}

\item{...}{Additional arguments passed to the metric function}
}
\value{
A dataframe with three rows representing average weekday, weekend,
and mean daily values for the specified metric
}
\description{
\code{mean_daily_metric} is a convenience wrapper around \code{mean_daily} that
summarizes data imported with LightLogR per weekday and calculates mean daily
values for a specific metric. Examples include \code{\link[=duration_above_threshold]{duration_above_threshold()}}
(the default), or \code{\link[=durations]{durations()}}.
}
\examples{

# Calculate mean daily duration above threshold. As the data only contains
# data for two days, Weekend and Mean daily will throw NA
sample.data.irregular |> 
aggregate_Datetime(unit = "1 min") |> 
mean_daily_metric(
  Variable = lux,
  threshold = 100
)

# again with another dataset
sample.data.environment |> 
  mean_daily_metric(
  Variable = MEDI,
  threshold = 250)

# by default, datetime columns are converted to time
sample.data.environment |> 
  mean_daily_metric(
  Variable = MEDI,
  metric_type = timing_above_threshold,
  threshold = 250)

}
