% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RoundingHelper.R
\name{RoundingHelper}
\alias{RoundingHelper}
\title{Helper object to define rounding rules for the InsuranceContract,
InsuranceTarif and ProfitParticipation classes.}
\description{
The class \code{RoundingHelper} provides the code and settings
to define numeric rounding rules for premiums, reserves, benefits etc. of
a life insurance contract. By default, no rounding it applied.
}
\examples{
# TODO

## ------------------------------------------------
## Method `RoundingHelper$new`
## ------------------------------------------------

rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))

## ------------------------------------------------
## Method `RoundingHelper$round`
## ------------------------------------------------

rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
# If the given spec does not exist, no rounding it applied
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))

## ------------------------------------------------
## Method `RoundingHelper$setRounding`
## ------------------------------------------------

rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
# If the given spec does not exist, no rounding it applied
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))
# Add a new spec with different settings:
rounding$setRounding("non-existing", 1)
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))

## ------------------------------------------------
## Method `RoundingHelper$getRounding`
## ------------------------------------------------

rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$getRounding("hundred")
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{rounding}}{The (named) list containing all declared rounding definitions}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-RoundingHelper-new}{\code{RoundingHelper$new()}}
\item \href{#method-RoundingHelper-round}{\code{RoundingHelper$round()}}
\item \href{#method-RoundingHelper-setRounding}{\code{RoundingHelper$setRounding()}}
\item \href{#method-RoundingHelper-getRounding}{\code{RoundingHelper$getRounding()}}
\item \href{#method-RoundingHelper-clone}{\code{RoundingHelper$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RoundingHelper-new"></a>}}
\if{latex}{\out{\hypertarget{method-RoundingHelper-new}{}}}
\subsection{Method \code{new()}}{
Initialize the rounding settings
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RoundingHelper$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{named entries specifying rounding accuracy}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Sets up the rounding helper by giving a list of named entries, specifying rounding accuracy for each particular value
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RoundingHelper-round"></a>}}
\if{latex}{\out{\hypertarget{method-RoundingHelper-round}{}}}
\subsection{Method \code{round()}}{
Round the given values using the pre-defined accuracy
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RoundingHelper$round(spec, value, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{spec}}{the ID used for looking up the desired accuracy}

\item{\code{value}}{the values to be rounded according to 'spec'}

\item{\code{...}}{currently unused}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Rounds the given values using the accuracies defined in the
internal rounding list (set either via the 'initialize' function
or via a call to 'setRounding'. The accuracies are defined using
a 'spec' identifier, which allows to define different accuracies
for different uses
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
# If the given spec does not exist, no rounding it applied
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RoundingHelper-setRounding"></a>}}
\if{latex}{\out{\hypertarget{method-RoundingHelper-setRounding}{}}}
\subsection{Method \code{setRounding()}}{
Define rounding accuracy for a certain identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RoundingHelper$setRounding(key, spec, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{the ID used for looking up the desired accuracy}

\item{\code{spec}}{the rounding accuracy (number of digits)}

\item{\code{...}}{currently unused}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Configures the rounding helper for a given named entry,
specifying rounding accuracy for each particular value
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$round("raw", c(1234.567891, 0.00012345, 1234))
rounding$round("hundred", c(1234.567891, 0.00012345, 1234))
rounding$round("accurate", c(1234.567891, 0.00012345, 1234))
# If the given spec does not exist, no rounding it applied
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))
# Add a new spec with different settings:
rounding$setRounding("non-existing", 1)
rounding$round("non-existing", c(1234.567891, 0.00012345, 1234))
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RoundingHelper-getRounding"></a>}}
\if{latex}{\out{\hypertarget{method-RoundingHelper-getRounding}{}}}
\subsection{Method \code{getRounding()}}{
Extract rounding accuracy for a certain identifier
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RoundingHelper$getRounding(key, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{key}}{the ID used for looking up the desired accuracy}

\item{\code{...}}{currently unused}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Read out the rounding for a given named entry.
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{rounding = RoundingHelper$new(raw = 0, hundred = -2, accurate = 4)
rounding$getRounding("hundred")
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-RoundingHelper-clone"></a>}}
\if{latex}{\out{\hypertarget{method-RoundingHelper-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{RoundingHelper$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
