% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LSWPbasis.R
\name{LSWPbasis}
\alias{LSWPbasis}
\title{Estimate an LSWP basis by penalised least squares}
\usage{
LSWPbasis(x, wavelet, lev.max, smooth, spa, penalty = 0.976)
}
\arguments{
\item{x}{a (locally stationary) time series of dyadic length.}

\item{wavelet}{the wavelet used to estimate the wavelet packet spectra.}

\item{lev.max}{the maximum scale for which the basis is fitted.}

\item{smooth}{should the penasised least squares cost functionals be smoothed? Default value is \code{TRUE}.}

\item{spa}{parameter for the local polynomial smothing implemented through \code{lowess}}

\item{penalty}{implemets increasing penalty for increasing scales.}
}
\value{
A matrix of dimensions |b| x 2, where |b| is the number of packets in the basis.
The first column contains the scale indices of each packet in the basis, the second column contains the packet index within each scale.
}
\description{
\code{LSWPbasis} returns a matrix containing the wavelet packet basis indices.
}
\details{
This function fits a wavelet packet basis to data using a penalised least square method.

This function implements a data-driven basis selection of locally stationary time series.
The wavelet argument is specified as in other functions of this package.
Therefore, the current implementation allows for three discrete wavelets: Haar (\code{"haar"}),
Daubechies Extremal Phase linear filters of length 4 (\code{"d4"}) and Least Asymmetric linear filters of length 8 (\code{"la8"}).
Smoothing is controlled through the argument spa.
}
\examples{

wpb <- LSWPbasis(x = sp500, wavelet = 'la8', lev.max = 4, smooth = TRUE, spa = 0.35)

}
\references{
A. Cardinali and G.P. Nason (2017). Locally Stationary Wavelet Packet Processes:
            Basis Selection and Model Fitting. Journal of Time Series Analysis, 38:2, 151-174.
}
\seealso{
\code{\link{LSWPspec}}, \code{\link{LSWPsim}}
}
\author{
Alessandro Cardinali
}
