% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ls_summary.R
\name{LS.summary}
\alias{LS.summary}
\title{Summary for Locally Stationary Time Series}
\usage{
LS.summary(object)
}
\arguments{
\item{object}{(type: list) the output of \code{\link{LS.whittle}} function}
}
\value{
A list with the following components:
\item{summary}{a resume table with estimate, std. error, z-value and p-value
of the model.}
\item{aic}{AIC of the model.}
\item{npar}{number of parameters in the model.}
}
\description{
Produces a summary of the results to Whittle
estimator to Locally Stationary Time Series (\code{\link{LS.whittle}}
function).
}
\details{
Calls the output from \code{\link{LS.whittle}} and computes the standard
error and p-values to provide a detailed summary.
}
\examples{
fit_whittle <- LS.whittle(
  series = malleco, start = c(1, 1, 1, 1),
  order = c(p = 1, q = 0), ar.order = 1, sd.order = 1, N = 180, n.ahead = 10
)
LS.summary(fit_whittle)
}
\seealso{
\code{\link{LS.whittle}}
}
