% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/11_CombinedAssessment.R
\name{LPD_CombAssess}
\alias{LPD_CombAssess}
\title{LPD_CombAssess}
\usage{
LPD_CombAssess(
  LandProd_change = NULL,
  LandProd_current = NULL,
  local_prod_threshold = 50,
  filename = ""
)
}
\arguments{
\item{LandProd_change}{SpatRaster object (or its file name). Land Productivity Long Term Change Map}

\item{LandProd_current}{SpatRaster object (or its file name). Land Productivity Current Status Map}

\item{local_prod_threshold}{Numeric. Potential local productivity threshold (within the Ecosystem Functional Type) in percentage. Optional. Default = 50}

\item{filename}{Character. Output filename. Optional}
}
\value{
SpatRaster
}
\description{
LPD_CombAssess combines a 'LandProd_change' map (SpatRaster) with a 'LandProd_current'
map (SpatRaster), giving a 5-classes map ranging from declining to increasing land
productivity. 'LandProd_current' is reclassified into two classes: pixels with less than 'local_prod_threshold'
(in percentage; 50 by default) of potential local productivity (within the EFT) and pixels with more or equal to
'local_prod_threshold'.

If 'LandProd_current' = NULL, 'LandProd_change' is directly reclassified into the same 5-classes map
without using 'LandProd_current'. See the ATBD for the way pixels are reclassified.
}
\details{
LandProd_change c(1:6, 8:9)       &  LandProd_current  < 'local_prod_threshold'  <- 1 Declining land productivity

LandProd_change c(3, 6)           &  LandProd_current >= 'local_prod_threshold'  <- 1 Declining land productivity

LandProd_change c(7)              &  LandProd_current  < 'local_prod_threshold'  <- 2 Early signs of decline of land productivity

LandProd_change c(1:2, 4:5, 8:9)  &  LandProd_current >= 'local_prod_threshold'  <- 2 Early signs of decline of land productivity

LandProd_change c(7)              &  LandProd_current >= 'local_prod_threshold'  <- 3 Negative fluctuation (stable, but stressed land prod.)

LandProd_change c(10:12)                                     <- 3 Negative fluctuation (stable, but stressed land prod.)
LandProd_change c(13:15)                                     <- 4 Positive fluctuation (stable, not stressed land prod.)

LandProd_change c(16:17, 19)      &  LandProd_current  < 'local_prod_threshold'  <- 4 Positive fluctuation (stable, not stressed land prod.)

LandProd_change c(18, 20:22)      &  LandProd_current  < 'local_prod_threshold'  <- 5 Increasing land productivity

LandProd_change c(16:22)          &  LandProd_current >= 'local_prod_threshold'  <- 5 Increasing land productivity


Values = 0 in the final map indicates that there is a scarcity of data in the productivity variable
(i.e. only 1 year with data), so that the indicator cannot be calculated

'local_prod_threshold' is the threshold used to classify 'LandProd_current' into pixels with low or high
potential productivity within its Ecosystem Functional Type
}
\examples{
\donttest{
sb <- terra::rast(paste0(system.file(package='LPDynR'), "/extdata/sb_cat.tif"))
SteadinessIndex_raster <- steadiness(obj2process = sb)
BaselineLevels_raster <- baseline_lev(obj2process = sb,
                                      yearsBaseline = 3,
                                      drylandProp = 0.4)
StateChange_raster <- state_change(obj2process = sb,
                                   yearsBaseline = 3)
LandProd_change_raster <- LongTermChange(SteadinessIndex = SteadinessIndex_raster,
                                         BaselineLevels = BaselineLevels_raster,
                                         StateChange = StateChange_raster)

dirctry <- paste0(system.file(package='LPDynR'), "/extdata")
variables_noCor <- rm_multicol(dir2process = dirctry,
                               multicol_cutoff = 0.7)
EFTs_raster <- EFT_clust(obj2clust = variables_noCor,
                         n_clust = 10)

LandProd_current_raster <- LNScaling(EFTs = EFTs_raster[[1]],
                                     ProdVar = sb)

LPD_CombAssess(LandProd_change = LandProd_change_raster,
               LandProd_current = LandProd_current_raster)
}

}
\seealso{
\code{\link{LongTermChange}}; \code{\link{LNScaling}}
}
\author{
Xavier Rotllan-Puig
}
