% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/llm.create.HTML.visualisation.cat.R
\name{table.cat.llm.html}
\alias{table.cat.llm.html}
\title{Create the HTML code for Logit Leaf Model visualization}
\usage{
table.cat.llm.html(
  object,
  category_var_df,
  headertext = "The Logit Leaf Model",
  footertext = "A table footer comment",
  roundingnumbers = 2,
  methodvarimp = "Coef"
)
}
\arguments{
\item{object}{An object of class logitleafmodel, as that created by the function llm.}

\item{category_var_df}{dataframe containing a column called "iv" with the independent variables and a column called "cat" with the variable category names that is associated with every iv}

\item{headertext}{Allows to provide the table with a header.}

\item{footertext}{Allows to provide the table with a custom footer.}

\item{roundingnumbers}{An integer stating the number of decimals in the visualization.}

\item{methodvarimp}{Allows to determine the method to calculate the variable importance. There are 4 options: 1/ Variable coefficent (method = 'Coef) 2/ Standardized beta ('Beta') 3/ Wald statistic ('Wald') 4/ Likelihood Rate Test ('LRT')}
}
\value{
Generates HTML code for a visualization.
}
\description{
This function generates HTML code for a visualization of the logit leaf model based on the variable importance per variable category.
}
\examples{
## Load PimaIndiansDiabetes dataset from mlbench package
if (requireNamespace("mlbench", quietly = TRUE)) {
  library("mlbench")
}
data("PimaIndiansDiabetes")
## Split in training and test (2/3 - 1/3)
idtrain <- c(sample(1:768,512))
PimaTrain <- PimaIndiansDiabetes[idtrain,]
Pimatest <- PimaIndiansDiabetes[-idtrain,]
## Create the LLM
Pima.llm <- llm(X = PimaTrain[,-c(9)],Y = PimaTrain$diabetes,
 threshold_pruning = 0.25,nbr_obs_leaf = 100)
## Define the variable categories (note: the categories are only created for demonstration)
var_cat_df <- as.data.frame(cbind(names(PimaTrain[,-c(9)]),
c("cat_a","cat_a","cat_a","cat_a","cat_b","cat_b","cat_b","cat_b")), stringsAsFactors = FALSE)
names(var_cat_df) <- c("iv", "cat")
## Save the output of the model to a html file
Pima.Viz <- table.cat.llm.html(object = Pima.llm,category_var_df= var_cat_df,
 headertext = "This is an example of the LLM model",
footertext = "Enjoy the package!")
## Optionaly write it to your working directory
# write(Pima.Viz, "Visualization_LLM_on_PimaIndiansDiabetes.html")
}
\references{
Arno De Caigny, Kristof Coussement, Koen W. De Bock, A New Hybrid Classification Algorithm for Customer Churn Prediction Based on Logistic Regression and Decision Trees, European Journal of Operational Research (2018), doi: 10.1016/j.ejor.2018.02.009.
}
\seealso{
\code{\link{predict.llm}}, \code{\link{llm}}, \code{\link{llm.cv}}
}
\author{
Arno De Caigny, \email{a.de-caigny@ieseg.fr}, Kristof Coussement, \email{k.coussement@ieseg.fr} and Koen W. De Bock, \email{kdebock@audencia.com}
}
