% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare.model.R
\name{compare.model}
\alias{compare.model}
\title{Model Comparison Tool}
\usage{
compare.model(object1, object2, n.Bootstrap = 0)
}
\arguments{
\item{object1}{An object of class \code{\link[LCPA]{LCA}} or \code{\link[LCPA]{LPA}}, representing
the first latent class/profile model.}

\item{object2}{An object of class \code{\link[LCPA]{LCA}} or \code{\link[LCPA]{LPA}}, representing
the second latent class/profile model. Must be of the same type as \code{object1}.}

\item{n.Bootstrap}{Integer specifying the number of bootstrap replications for the parametric
bootstrap likelihood ratio test (BLRT). Default is \code{0} (no bootstrap test performed).}
}
\value{
An object of class \code{compare.model} containing:
\describe{
\item{\code{npar}}{Named vector with number of free parameters for each model}
\item{\code{entropy}}{Named vector with entropy values (classification accuracy measure) for each model}
\item{\code{AvePP}}{List containing average posterior probabilities per latent class/profile}
\item{\code{fit.index}}{List of \code{\link[LCPA]{get.fit.index}} objects for both models}
\item{\code{BF}}{Bayes Factor for model comparison (based on SIC)}
\item{\code{LRT.obj}}{Likelihood ratio test (LRT) results}
\item{\code{LRT.VLMR.obj}}{Vuong-Lo-Mendell-Rubin (VLMR) adjusted LRT results}
\item{\code{LRT.Bootstrap.obj}}{Bootstrap LRT results (if \code{n.Bootstrap > 0})}
\item{\code{call}}{The matched function call}
\item{\code{arguments}}{List containing the original arguments passed to the function}
}
}
\description{
Compares two nested latent class/profile models using multiple fit indices, likelihood ratio tests, and classification metrics.
}
\details{
This function performs comprehensive model comparison between two nested LCA/LPA models. Key features include:
\itemize{
\item Automatically orders models by parameter count (smaller model first)
\item Computes multiple fit indices via \code{\link[LCPA]{get.fit.index}}
\item Calculates classification quality metrics (entropy, average posterior probabilities)
\item Performs three types of likelihood ratio tests:
\itemize{
\item Standard LRT, see \code{\link[LCPA]{LRT.test}}
\item VLMR adjusted LRT, see \code{\link[LCPA]{LRT.test.VLMR}}
\item Parametric bootstrap LRT (computationally intensive but robust), see \code{\link[LCPA]{LRT.test.Bootstrap}}
}
\item Computes Bayes Factor using Sample-Size Adjusted BIC (SIC)
}

\strong{Important Requirements}:
\itemize{
\item Both models must be of the same type (\code{LCA} or \code{LPA})
\item Models must be nested (one model is a constrained version of the other)
\item \code{n.Bootstrap > 0} requires significant computational resources
}
}
\examples{
library(LCPA)
set.seed(123)

data.obj <- sim.LPA(N = 500, I = 5, L = 3, constraint = "V0")
response <- data.obj$response

# need Mplus
\dontrun{
# Compare 3-class vs 4-class LPA models
object1 <- LPA(response, L = 3, method = "Mplus", constraint = "V0")
object2 <- LPA(response, L = 4, method = "Mplus", constraint = "V0")

compare.model.obj <- compare.model(object1, object2)

print(compare.model.obj)
}

}
\seealso{
\code{\link[LCPA]{LCA}}, \code{\link[LCPA]{LPA}}, \code{\link[LCPA]{get.fit.index}},
\code{\link[LCPA]{extract}}, \code{\link[LCPA]{LRT.test}}, \code{\link[LCPA]{LRT.test.VLMR}}
}
