% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{LBSPR_NLLgtg}
\alias{LBSPR_NLLgtg}
\title{LBSPR Optimization function for GTG model}
\usage{
LBSPR_NLLgtg(
  starts,
  LMids,
  LBins,
  LDat,
  gtgLinfs,
  MKMat,
  MK,
  Linf,
  ngtg,
  recP,
  usePen
)
}
\arguments{
\item{starts}{a vector of starting parameters, relative SL50 (SL50/Linf), deltaSL (SL95-SL50)/Linf, and F/M (in log space)}

\item{LMids}{a vector of the midpoints of the length classes}

\item{LBins}{a vector of length classes}

\item{LDat}{a vector of lenght frequencies. Must be same length as LMids}

\item{gtgLinfs}{a vector of Linfs for the growth-type-groups}

\item{MKMat}{a matrix of M/K for each GTG and length-class}

\item{MK}{the M/K value}

\item{Linf}{the Linf value for the population as a hole}

\item{ngtg}{the number of growth-type-groups}

\item{recP}{a vector of recruitment by GTG}

\item{usePen}{logical to use penalty for extreme estimates of selectivity}
}
\value{
negative log-likelihood value
}
\description{
Internal optimization function
}
\author{
A. Hordyk
}
