% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pubmed_search.R
\name{ncbi_search}
\alias{ncbi_search}
\title{Search NCBI databases for articles or data}
\usage{
ncbi_search(
  query,
  database = "pubmed",
  max_results = 1000,
  use_mesh = FALSE,
  date_range = NULL,
  api_key = NULL,
  retry_count = 3,
  retry_delay = 2
)
}
\arguments{
\item{query}{Character string containing the search query.}

\item{database}{Character string. The NCBI database to search (e.g., "pubmed", "pmc", "gene", "protein").}

\item{max_results}{Maximum number of results to return.}

\item{use_mesh}{Logical. If TRUE, will attempt to map query terms to MeSH terms (for PubMed only).}

\item{date_range}{Character vector of length 2 with start and end dates in format "YYYY/MM/DD".}

\item{api_key}{Character string. NCBI API key for higher rate limits (optional).}

\item{retry_count}{Integer. Number of times to retry failed requests.}

\item{retry_delay}{Integer. Delay between retries in seconds.}
}
\value{
A data frame containing the search results with IDs, titles, and other metadata.
}
\description{
This function searches various NCBI databases using the E-utilities API via the rentrez package.
}
