% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/text_preprocessing.R
\name{load_dictionary}
\alias{load_dictionary}
\title{Load biomedical dictionaries with improved error handling}
\usage{
load_dictionary(
  dictionary_type = NULL,
  custom_path = NULL,
  source = c("local", "mesh", "umls"),
  api_key = NULL,
  n_terms = 200,
  mesh_query = NULL,
  semantic_type_filter = NULL,
  sanitize = TRUE,
  extended_mesh = FALSE,
  mesh_queries = NULL
)
}
\arguments{
\item{dictionary_type}{Type of dictionary to load. For local dictionaries, limited to "disease", "drug", "gene".
For MeSH and UMLS, expanded to include more semantic categories.}

\item{custom_path}{Optional path to a custom dictionary file.}

\item{source}{The source to fetch terms from: "local", "mesh", or "umls".}

\item{api_key}{UMLS API key for authentication (required if source = "umls").}

\item{n_terms}{Number of terms to fetch.}

\item{mesh_query}{Additional query to filter MeSH terms (only if source = "mesh").}

\item{semantic_type_filter}{Filter by semantic type (used mainly with UMLS).}

\item{sanitize}{Logical. If TRUE, sanitizes the dictionary terms.}

\item{extended_mesh}{Logical. If TRUE and source is "mesh", uses PubMed search for additional terms.}

\item{mesh_queries}{Named list of MeSH queries for different categories (only if extended_mesh = TRUE).}
}
\value{
A data frame containing the dictionary.
}
\description{
This function loads pre-defined biomedical dictionaries or fetches terms from MeSH/UMLS.
}
