% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_similarity.R
\name{calc_doc_sim}
\alias{calc_doc_sim}
\title{Calculate document similarity using TF-IDF and cosine similarity}
\usage{
calc_doc_sim(
  text_data,
  text_column = "abstract",
  min_term_freq = 2,
  max_doc_freq = 0.9
)
}
\arguments{
\item{text_data}{A data frame containing text data.}

\item{text_column}{Name of the column containing text to analyze.}

\item{min_term_freq}{Minimum frequency for a term to be included.}

\item{max_doc_freq}{Maximum document frequency (as a proportion) for a term to be included.}
}
\value{
A similarity matrix for the documents.
}
\description{
This function calculates the similarity between documents using TF-IDF weighting
and cosine similarity.
}
