% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/L1centGROUP.R
\name{group_reduce}
\alias{group_reduce}
\alias{group_reduce.igraph}
\alias{group_reduce.matrix}
\title{Group Reduced Graph}
\usage{
group_reduce(g, nodes, eta, method, weight_transform)

\method{group_reduce}{igraph}(
  g,
  nodes,
  eta = NULL,
  method = c("minimum", "maximum", "average"),
  weight_transform = NULL
)

\method{group_reduce}{matrix}(g, nodes, eta = NULL, method = "minimum", weight_transform = NULL)
}
\arguments{
\item{g}{An \code{igraph} graph object or a distance matrix. Here, the
\ifelse{html}{\out{(<i>i,j</i>)}}{\eqn{(i,j)}} component of the distance
matrix is the geodesic distance from the
\ifelse{html}{\out{<i>i</i>}}{\eqn{i}}th vertex to the
\ifelse{html}{\out{<i>j</i>}}{\eqn{j}}th vertex.}

\item{nodes}{A vector of integers. Each integer indicates the index of the
vertex.}

\item{eta}{An optional nonnegative multiplicity (weight) vector for (vertex)
weighted networks. The sum of its components must be positive. If set to
\code{NULL} (the default), all vertices will have the same positive weight
(multiplicity) of 1, i.e., \code{g} is treated as a vertex unweighted graph. The
length of the \code{eta} must be equivalent to the number of vertices.}

\item{method}{A character string. It specifies the method of setting the edge
weight between the pseudo-vertex and the other vertices. Note that the S3
method for the \code{matrix} class only supports the \code{minimum} option. This
is because it is not possible to derive the group reduced graph's distance
matrix from the original distance matrix when using the maximum or average
method. On the other hand, the group reduced graph's distance matrix can be
derived from the original distance matrix when the minimum method is used.
See the discussion in Kang (2025).
\itemize{
\item \code{minimum} (the default): the minimum method is used in setting the edge weights.
\item \code{maximum}: the maximum method is used in setting the edge weights.
\item \code{average}: the average method is used in setting the edge weights.
}}

\item{weight_transform}{An optional function to transform the edge weights
when \code{g} is an \code{igraph} object and an edge weight attribute exists. This
argument is ignored when \code{g} is a distance matrix.}
}
\value{
A list consisting of three objects:
\itemize{
\item \sQuote{distmat}: A matrix representing the group reduced graph's
distance matrix, where the first row and column correspond to the
pseudo-vertex.
\item \sQuote{eta}: A vector of the group reduced graph's vertex
multiplicity. The first element corresponds to the pseudo-vertex.
\item \sQuote{label}: A vector of the vertex names specified by \code{nodes}.
}
}
\description{
Computes the vertex multiplicities (weights) and the distance matrix of the
group reduced graph. The group reduced graph is constructed by replacing a
group of vertices in the original graph by a single \sQuote{pseudo-vertex}.
}
\details{
The group reduced graph is constructed by replacing the vertices indicated in
the argument \code{nodes} with a single \sQuote{pseudo-vertex}. The
multiplicity (weight) of this new vertex is set to the sum of the
multiplicities of the vertices within \code{nodes}. An edge from the
pseudo-vertex to any vertex that is not in \code{nodes}, say
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}}, is created in the group reduced graph if
there is at least one edge from the vertices in \code{nodes} to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} in the original graph. The weight of
this newly added edge is determined using one of the following methods:
\itemize{
\item Minimum method: The edge weight from the pseudo-vertex to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} is set to the minimum of the edge
weights of the edges between the vertices in \code{nodes} to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} in the original graph.
\item Maximum method: The edge weight from the pseudo-vertex to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} is set to the maximum of the edge
weights of the edges between the vertices in \code{nodes} to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} in the original graph.
\item Average method: The edge weight from the pseudo-vertex to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} is set to the average of the edge
weights of the edges between the vertices in \code{nodes} to
\ifelse{html}{\out{<i>v</i>}}{\eqn{v}} in the original graph.
}
An edge from \ifelse{html}{\out{<i>v</i>}}{\eqn{v}} to the pseudo-vertex is
set in a similar manner. For details, refer to Kang (2025).
}
\note{
Multiple edges (edges with the same head and tail vertices) are not allowed,
because they make the edge weight setting procedure confusing.
}
\examples{
# Group reduced graph of the 'Iron Man' series using the minimum method
vertex_weight <- igraph::V(MCUmovie)$worldwidegross
ironman_series <- c(1,3,7)
reduced_graph <- group_reduce(MCUmovie, nodes = ironman_series, eta = vertex_weight)
reduced_graph$distmat[1:3,1:3]
reduced_graph$label

# Multiplicity of the pseudo-vertex equals the sums of the replaced vertices' multiplicities
reduced_graph$eta[1] == sum(vertex_weight[ironman_series])
}
\references{
S. Kang. \emph{Topics in Non-Euclidean Dimension Reduction}. PhD thesis,
Seoul National University, 2025.
}
\seealso{
\code{\link[=L1cent]{L1cent()}} for
\ifelse{html}{\out{<i>L</i><sub>1</sub>}}{{\eqn{L_1}}} centrality/prestige.
\code{\link[=L1centGROUP]{L1centGROUP()}} internally uses \code{group_reduce()}.
}
