% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{plot.L0LearnCV}
\alias{plot.L0LearnCV}
\title{Plot Cross-validation Errors}
\usage{
\method{plot}{L0LearnCV}(x, gamma = 0, ...)
}
\arguments{
\item{x}{The output of L0Learn.cvfit}

\item{gamma}{The value of gamma at which to plot.}

\item{...}{ignore}
}
\value{
A \code{ggplot} object.
}
\description{
Plots cross-validation errors for a given gamma.
}
\examples{
# Generate synthetic data for this example
data <- GenSynthetic(n=100,p=20,k=10,seed=1)
X = data$X
y = data$y

# Perform 3-fold cross-validation on an L0L2 Model with 3 values of
# Gamma ranging from 0.0001 to 10
fit <- L0Learn.cvfit(X, y, nFolds=3, seed=1, penalty="L0L2",
maxSuppSize=20, nGamma=3, gammaMin=0.0001, gammaMax = 10)
# Plot the graph of cross-validation error versus lambda for gamma = 0.0001
plot(fit, gamma=0.0001)

}
