% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedigree.r
\name{penetrance}
\alias{penetrance}
\title{Likelihood function for calculation of Pedigree-based autosomal dominant penetrance value.
Formula deployed via optimize so as to determine the optimal value.}
\usage{
penetrance(K, a, b, c, d, n)
}
\arguments{
\item{K}{The range of penetrance values to be explored by the optimization function.}

\item{a}{Count of affected individuals}

\item{b}{Count of obligate carriers}

\item{c}{Count of children of either affecteds or carriers, with no children of their own}

\item{d}{Count of trees of unaffected individuals - specifically, two sequential generations (i.e. a parent and their offspring)}

\item{n}{Count of the number of second generation progeny in a given tree.}
}
\value{
K Pedigree-based estimation of autosomal dominant penetrance rate.
}
\description{
Likelihood function for calculation of Pedigree-based autosomal dominant penetrance value.
Formula deployed via optimize so as to determine the optimal value.
}
\examples{
K <- optimize(penetrance, c(0,1), 3, 1, 5, 2, 1, maximum=TRUE)$max
}
