% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/encoding.R
\name{assign.status}
\alias{assign.status}
\title{Take a disease status and a genetic variant and determine which category the combo falls in.
A.c = Affected individual with ALT variant
A.i = Affected individual without ALT variant
U.c = Unaffected individual without ALT variant
U.i = Unaffected individual with ALT variant
If theoretical.max = TRUE the true variant statuses are ignored and all
affected/unaffected are assigned A.c and U.c respectively.
These encoding can then be used show what a family's max score would be.}
\usage{
assign.status(status, variant, theoretical.max = FALSE)
}
\arguments{
\item{status}{Disease status of an individual. A = affected, U = unaffected.}

\item{variant}{Variant for individual. genotypes, phased genotypes, or binary encodings accepted.}

\item{theoretical.max}{Should the theoretical maxima be returned instead of the observed values?
When true, the scoring assumes correct variant-status pair for each individual.
Default is FALSE.}
}
\value{
a string
}
\description{
Take a disease status and a genetic variant and determine which category the combo falls in.
A.c = Affected individual with ALT variant
A.i = Affected individual without ALT variant
U.c = Unaffected individual without ALT variant
U.i = Unaffected individual with ALT variant
If theoretical.max = TRUE the true variant statuses are ignored and all
affected/unaffected are assigned A.c and U.c respectively.
These encoding can then be used show what a family's max score would be.
}
\examples{
assign.status("A", "0/1") == "A.c"
assign.status("A", "0|0") == "A.i"
assign.status("U", 1) == "U.i"
assign.status("U", "0|0") == "U.c"
}
