# KWELA 1.0.0

## Initial CRAN Release

### 6-Layer Hierarchical Architecture
* **Layer 1: Hard Gate** - Biological constraint filter with stochastic rescue (research mode only)
* **Layer 2: Per-Well Scoring** - Profile-dependent adaptive transforms
* **Layer 3: Adaptive Combination** - Separation-aware score combiner
* **Layer 4: Adaptive Cutoff** - Youden-optimized threshold per plate/group
* **Layer 5: Replicate Consensus** - Treatment-level classification
* **Layer 6: Instability Detection** - Matrix interference override

### Dual-Mode Operation
* `mode = "diagnostic"` (default): Deterministic classification from TTT/MP/RAF evidence only. No stochastic rescue, no stochastic score blending.
* `mode = "research"`: Full adaptive architecture with stochastic rescue and distributional scoring.

### Instability Detection
* `compute_instability_flags()`: 6 deterministic metrics per treatment (Fano deviation, crossing variability, Wasserstein/Energy distance from both controls, TTT dispersion, RAF-MP inconsistency)
* Configurable strictness: `"moderate"` (2+ flags), `"strict"` (1+), `"lenient"` (3+)
* Override: `INCONCLUSIVE_MATRIX_EFFECT` when minimum flags exceeded

### Auto-Profile Selection
* `profile = "auto"` selects based on Cohen's d separation quality

### Group-Aware Mixed-Assay Support
* Per-group PC/NC distributions, stats, thresholds, and RAF parameters
* Enables mixed RT-QuIC + Nano-QuIC under single `kwela_analyze()` call

### RAF Integration
* Artifact detection via RAF/MP ratio analysis
* RAF concordance scoring for quality assessment

### Replicate Consensus Rules
* `"strict"`, `"majority"` (default), `"flexible"`, `"threshold"`

### Stochastic Metrics Library
* Energy distance, Wasserstein distance, Jensen-Shannon divergence
* CRPS, Dawid-Sebastiani, interval score
* SSMD, Fano factor, coefficient of variation
* Cohen's d separation assessment
