% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/KPC.R
\name{KFOCI}
\alias{KFOCI}
\title{Kernel Feature Ordering by Conditional Independence}
\usage{
KFOCI(
  Y,
  X,
  k = kernlab::rbfdot(1/(2 * stats::median(stats::dist(Y))^2)),
  Knn = min(ceiling(NROW(Y)/20), 20),
  num_features = NULL,
  stop = TRUE,
  numCores = parallel::detectCores(),
  verbose = FALSE
)
}
\arguments{
\item{Y}{a matrix of responses (n by dy)}

\item{X}{a matrix of predictors (n by dx)}

\item{k}{a function \eqn{k(y, y')} of class \code{kernel}. It can be the kernel implemented in \code{kernlab} e.g., Gaussian kernel: \code{rbfdot(sigma = 1)}, linear kernel: \code{vanilladot()}.}

\item{Knn}{a positive integer indicating the number of nearest neighbor; or "MST". The suggested choice of Knn is 0.05n for samples up to a few hundred observations. For large n, the suggested Knn is sublinear in n. That is, it may grow slower than any linear function of n. The computing time is approximately linear in Knn. A smaller Knn takes less time.}

\item{num_features}{the number of variables to be selected, cannot be larger than dx. The default value is NULL and in that
case it will be set equal to dx. If \code{stop == TRUE} (see below), then num_features is the maximal number of variables to be selected.}

\item{stop}{If \code{stop == TRUE}, then the automatic stopping criterion (stops at the first instance of negative Tn, as mentioned in the paper) will be implemented and continued till \code{num_features} many variables are selected. If \code{stop == FALSE} then exactly \code{num_features} many variables are selected.}

\item{numCores}{number of cores that are going to be used for parallelizing the process.}

\item{verbose}{whether to print each selected variables during the forward stepwise algorithm}
}
\value{
The algorithm returns a vector of the indices from 1,...,dx of the selected variables in the same order that they were selected. The variables at the front are expected to be more informative in predicting Y.
}
\description{
Variable selection with KPC using directed K-NN graph or minimum spanning tree (MST)
}
\details{
A stepwise forward selection of variables using KPC. At each step it selects the \eqn{X_j} that maximizes
\eqn{\hat{\rho^2}(Y,X_j |}selected \eqn{X_i)}.
It is suggested to normalize the predictors before applying KFOCI.
Euclidean distance is used for computing the K-NN graph and the MST.
}
\examples{
n = 200
p = 10
X = matrix(rnorm(n * p), ncol = p)
Y = X[, 1] * X[, 2] + sin(X[, 1] * X[, 3])
KFOCI(Y, X, kernlab::rbfdot(1), Knn=1, numCores=1)
# 1 2 3
}
\seealso{
\code{\link{KPCgraph}}, \code{\link{KPCRKHS}}, \code{\link{KPCRKHS_VS}}
}
