% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addTotals.R
\name{getTotals}
\alias{getTotals}
\alias{addTotals}
\title{Get LR totals}
\usage{
getTotals(x, cols = c("LRlinked", "LRnolink", "LRnomut"))

addTotals(x, cols = c("LRlinked", "LRnolink", "LRnomut"))
}
\arguments{
\item{x}{A data frame with LR results, typically the output of \code{\link[=linkedLR]{linkedLR()}}.}

\item{cols}{A vector of column names, by default \code{c("LRlinked", "LRnolink", "LRnomut")}}
}
\value{
\code{getTotals()} returns a named numeric. \code{addTotals} returns a data
frame equal to the input, but with a row of totals added at the bottom.
}
\description{
Find, or add, the LR totals in a data frame with marker-wise LR values. The
totals are found by multiplying the values in each column, after removing
\code{NA}'s.
}
\details{
Note that for the multiplication to respect linked markers, the input table
should include LR values for only one marker in each linkage group, and
\code{NA}'s elsewhere. This is the format used by \code{\link[=linkedLR]{linkedLR()}}.
}
\examples{
res = linkedLR(paternity)
getTotals(res)
addTotals(res)

}
